<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );

if ( ! empty( $product_tabs ) ) : ?>

    <section class="product-details-tab-section pb-120">
        <div class="container">
            <div class="row">

                <div class="col-xl-9">

                    <div class="woocommerce-tabs wc-tabs-wrapper product-details-tab-content">
                        <ul class="tabs wc-tabs nav nav-tabs py-3 px-4 border-0" role="tablist">
                            <?php
                            $i = 1;
                            foreach ( $product_tabs as $key => $product_tab ) :
                                $active = $i == 1 ? 'class=active' : '';
                                $aria_selected = $i == 1 ? 'true' : 'false';
                                ?>
                                <li>
                                    <a href="#tab-<?php echo esc_attr( $key ); ?>" <?php echo esc_attr($active) ?> data-bs-toggle="tab" aria-selected="<?php echo esc_attr($aria_selected) ?>" role="tab">
                                        <?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?>
                                    </a>
                                </li>
                                <?php
                                ++$i;
                            endforeach;
                            ?>
                        </ul>
                        <div class="tab-content mt-30">
	                        <?php
                            $i = 1;
                            foreach ( $product_tabs as $key => $product_tab ) :
	                            $show_active = $i == 1 ? ' show active' : '';
                                ?>
                                <div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--<?php echo esc_attr( $key ); ?> panel entry-content wc-tab tab-pane fade<?php echo esc_attr($show_active) ?>" id="tab-<?php echo esc_attr( $key ); ?>" role="tabpanel">
			                        <?php
			                        if ( isset( $product_tab['callback'] ) ) {
				                        call_user_func( $product_tab['callback'], $key, $product_tab );
			                        }
			                        ?>
                                </div>
	                            <?php
	                            ++$i;
                            endforeach;
                            ?>

	                        <?php do_action( 'woocommerce_product_after_tabs' ); ?>
                        </div>
                    </div>

                </div>


                <!--sidebar-->
                <div class="col-xl-3">

                    <div class="product-details-sidebar mt-5 mt-xl-0">
                        <div class="shop-sidebar-widget shop-products-widget py-4 px-3 border-top bg-white overflow-hidden">
                            <h6 class="pb-30 mb-0 pd-widget-title"><?php esc_html_e( 'Latest Products', 'autohive' ); ?></h6>
                            <ul class="products mt-4">
                                <?php
                                $args = array(
	                                'post_type'     => 'product',
	                                'post_status'   => 'publish',
	                                'posts_per_page'   => 3,
	                                'orderby'       => 'date',
	                                'order'         => 'DESC',
                                );

                                $recent_posts = new \WP_Query($args);

                                while ( $recent_posts->have_posts()) :
	                                $recent_posts->the_post();
                                    ?>
                                    <li class="d-flex align-items-center">
                                        <a href="<?php the_permalink(); ?>" class="feature-thumb border rounded d-flex align-items-center justify-content p-1">
			                                <?php the_post_thumbnail('autohive_70x70', [ 'class' => 'img-fluid'] ); ?>
                                        </a>
                                        <div class="content-right ms-3">
			                                <?php autohive_the_woo_product_ratting() ?>
                                            <a href="<?php the_permalink(); ?>" class="title">
				                                <?php echo wp_trim_words(get_the_title(), 8, '') ?>
                                            </a>
			                                <?php woocommerce_template_loop_price(); ?>
                                        </div>
                                    </li>
                                    <?php
                                endwhile;
                                wp_reset_postdata();
                                ?>

                            </ul>
                        </div>


                        <?php
                        $popular_args = array(
	                        'post_type'     => 'product',
	                        'post_status'   => 'publish',
	                        'posts_per_page'   => 3,
	                        'meta_key'       => 'post_views_count',
	                        'orderby'       => 'meta_value_num',
	                        'order'         => 'DESC',
                        );

                        $popular_posts = new \WP_Query($popular_args);

                        if ( $popular_posts->have_posts()) {
                            ?>
                            <div class="shop-sidebar-widget shop-products-widget py-4 px-3 border-top bg-white overflow-hidden mt-4">
                                <h6 class="pb-30 mb-0 pd-widget-title"><?php esc_html_e( 'Recently Viewed', 'autohive' ); ?></h6>
                                <ul class="products mt-4">
			                        <?php
			                        while ($popular_posts->have_posts()) : $popular_posts->the_post();
				                        ?>
                                        <li class="d-flex align-items-center">
                                            <a href="<?php the_permalink(); ?>" class="feature-thumb border rounded d-flex align-items-center justify-content p-1">
						                        <?php the_post_thumbnail('autohive_70x70', [ 'class' => 'img-fluid'] ); ?>
                                            </a>
                                            <div class="content-right ms-3">
						                        <?php autohive_the_woo_product_ratting(); ?>
                                                <a href="<?php the_permalink(); ?>" class="title">
	                                                <?php echo wp_trim_words(get_the_title(), 8, '') ?>
                                                </a>
						                        <?php woocommerce_template_loop_price(); ?>
                                            </div>
                                        </li>
			                        <?php
			                        endwhile;
			                        wp_reset_query();
			                        ?>
                                </ul>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php endif; ?>
