<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.3.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

if ( ! comments_open() ) {
	return;
}

?>
<div id="reviews" class="woocommerce-Reviews review-tab-box bg-white rounded pt-30 pb-40 px-4">

    <div class="d-flex flex-wrap align-items-center justify-content-between">
        <div class="top-left">
            <h5 class="mb-2">
	            <?php
	            $count = $product->get_review_count();
	            if ( $count && wc_review_ratings_enabled() ) {
		            /* translators: 1: reviews count 2: product name */
		            $reviews_title = sprintf( esc_html( _n( '%1$s review for "%2$s"', '%1$s reviews for %2$s', $count, 'woocommerce' ) ), esc_html( $count ), '<span>' . get_the_title() . '</span>' );
		            echo apply_filters( 'woocommerce_reviews_title', $reviews_title, $count, $product ); // WPCS: XSS ok.
	            } else {
		            esc_html_e( 'Reviews', 'woocommerce' );
	            }
	            ?>
            </h5>
            <p class="mb-0"><?php esc_html_e( 'Get specific details about this product from customers who own it.', 'autohive' ); ?></p>
            <?php woocommerce_template_single_rating(); ?>
        </div>
    </div>

    <hr class="mt-4 mb-4">

	<div id="comments">
		<?php if ( have_comments() ) : ?>
			<ul class="users_review">
				<?php wp_list_comments( apply_filters( 'woocommerce_product_review_list_args', array( 'callback' => 'autohive_woocommerce_comments' ) ) ); ?>
			</ul>
			<?php
			if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
				echo '<nav class="woocommerce-pagination">';
				paginate_comments_links(
					apply_filters(
						'woocommerce_comment_pagination_args',
						array(
							'prev_text' => is_rtl() ? '&rarr;' : '&larr;',
							'next_text' => is_rtl() ? '&larr;' : '&rarr;',
							'type'      => 'list',
						)
					)
				);
				echo '</nav>';
			endif;
			?>
		<?php else : ?>
			<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'woocommerce' ); ?></p>
		<?php endif; ?>
	</div>

    <hr class="mt-40 mb-40">

	<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) : ?>
		<div class="comment_form_wrapper users_review" id="review_form_wrapper">
            <?php
            $commenter    = wp_get_current_commenter();
            $name_email_required = (bool) get_option( 'require_name_email', 1 );
            $comment_form = array(
                /* translators: %s is product title */
                'title_reply'           => have_comments() ? esc_html__( 'Add Your review', 'woocommerce' ) : sprintf( esc_html__( 'Be the first to review &ldquo;%s&rdquo;', 'woocommerce' ), get_the_title() ),
                /* translators: %s is product title */
                'title_reply_to'        => esc_html__( 'Leave a Reply to %s', 'woocommerce' ),
                'title_reply_before'    => '<h4 id="reply-title" class="comment-reply-title">',
                'title_reply_after'     => '</h4>',
                'class_form'            => 'comment_form',
                'comment_notes_before'  => '',
                'comment_notes_after'   => '',
                'fields'                => array(
                    'author' => '<div class="col-sm-6"><div class="input-field">
                            <input type="text" name="author" placeholder="'.esc_attr__( 'Name *', 'autohive' ).'" value="'.esc_attr( $commenter['comment_author'] ).'" required="'.$name_email_required.'">
                         </div></div>',
                    'email'  => '<div class="col-sm-6"><div class="input-field">
                            <input name="email" type="text" placeholder="'.esc_attr__( 'Email *', 'autohive' ).'" value="'.esc_attr( $commenter['comment_author_email'] ).'" required="'.$name_email_required.'">
                         </div></div>',
                ),
                'comment_field'         => '',
                'id_submit'             => '',
                'class_submit'          => 'btn btn-primary mt-30',
                'label_submit'          => esc_html__( 'Submit', 'woocommerce' ),
                'submit_button'         => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s">'. esc_html__( 'Submit', 'autohive' ).'</button>',
                'logged_in_as'          => '',
            );

            $account_page_url = wc_get_page_permalink( 'myaccount' );
            if ( $account_page_url ) {
	            /* translators: %s opening and closing link tags respectively */
	            $comment_form['must_log_in'] = '<p class="must-log-in">' . sprintf( esc_html__( 'You must be %1$slogged in%2$s to post a review.', 'woocommerce' ), '<a href="' . esc_url( $account_page_url ) . '">', '</a>' ) . '</p>';
            }

            $comment_form['comment_field'] .= '<div class="col-sm-12"><div class="input-field"><textarea id="comment" name="comment" placeholder="'.esc_attr__('Your review', 'autohive').'" rows="5" required></textarea></div></div>';


            if ( wc_review_ratings_enabled() ) {
	            $comment_form['comment_field'] .= '<div class="comment-form-rating"><label for="rating">' . esc_html__( 'Your rating', 'woocommerce' ) . ( wc_review_ratings_required() ? '&nbsp;<span class="required">*</span>' : '' ) . '</label><select name="rating" id="rating" required>
						<option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
						<option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
						<option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
						<option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
						<option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
						<option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
					</select></div>';
            }

            comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
            ?>
		</div>
	<?php else : ?>
		<p class="woocommerce-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'woocommerce' ); ?></p>
	<?php endif; ?>

	<div class="clear"></div>
</div>
