<?php
/**
 * Template part for displaying page content in header.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package autohive
 */
$meta = get_post_meta( get_the_ID(), 'tt_page_options', true );
$is_cta_enabled = isset( $meta['is_cta_enabled'] ) ? $meta['is_cta_enabled'] : '';
$mobile_logo    = autohive_opt( 'mobile_logo' );
$ml_ratina      = autohive_opt( 'mobile_retina_logo' );
$sticky         = autohive_opt( 'sticky_logo' );
$retina_sticky  = autohive_opt( 'retina_logo_sticky' );
$is_contact_info = autohive_opt( 'is_contact_info', false );
$canvas_logo	= autohive_opt( 'canvas_logo' );
$canvas_title	= autohive_opt( 'canvas_title' );
$canvas_contents	= autohive_opt( 'canvas_contents' );
$canvas_btn_label	= autohive_opt( 'canvas_btn_label' );
$canvas_btn_url	= autohive_opt( 'canvas_btn_url' );
$contact_title	= autohive_opt( 'contact_title' );
$contact_address= autohive_opt( 'contact_address' );
$contact_number = autohive_opt( 'contact_phone' );
$contact_email	= autohive_opt( 'contact_email' );
$social_links 	= autohive_opt( 'social_links' );
?>
	<!--mobile menu start-->
    <div class="mobile-menu position-fixed bg-white deep-shadow">
        <button class="close-menu position-absolute"><i class="fa-solid fa-xmark"></i></button>
        <?php
        if (!empty( $mobile_logo['url']) ) {
            echo '<a href="'. esc_url( home_url('/') ) .'" class="logo-wrapper bg-secondary d-block mt-4 p-3 rounded-1 text-center"><img src="'. esc_url( $mobile_logo['url'] ).'" alt="'. esc_attr( get_bloginfo( 'name' ) ) .'" class="img-fluid"></a>';
        }
        elseif (!empty( $sticky['url']) ) {
            echo '<a href="'. esc_url( home_url('/') ) .'" class="logo-wrapper bg-secondary d-block mt-4 p-3 rounded-1 text-center"><img src="'. esc_url( $sticky['url'] ).'" alt="'. esc_attr( get_bloginfo( 'name' ) ) .'" class="img-fluid"></a>';
        }
        else {
            echo '<a href="'. esc_url( home_url('/') ) .'" class="logo-wrapper bg-secondary d-block mt-4 p-3 rounded-1 text-center"><h1>'. esc_html( get_bloginfo( 'name' ) ) .'</h1></a>';
        }
        ?>
        <nav class="mobile-menu-wrapper mt-40">
            <?php
            if ( has_nav_menu( 'main_menu' ) ) {
                wp_nav_menu( array (
                    'theme_location' => 'main_menu',
                    'container' => null,
                    'menu_class' => '',
                    'walker' => new Autohive_Main_Nav_Walker(),
                    'depth' => 3
                ));
            }
            ?>
        </nav>
        <div class="contact-info mt-60">
            <?php
            if ( $is_contact_info == '1' ) {
	            if ( !empty( $contact_title ) ) {
		            echo '<h4 class="mb-20">'. esc_html( $contact_title ) .'</h4>';
	            }
	            if ( !empty( $contact_address ) ) {
		            echo '<p>'. esc_html( $contact_address ) .'</p>';
	            }
	            if ( !empty( $contact_number ) ) {
		            echo '<p>'. esc_html( $contact_number ) .'</p>';
	            }
	            if ( !empty( $contact_email ) ) {
		            echo '<p>'. esc_html( $contact_email ) .'</p>';
	            }
	            // Social links
	            if ( is_array( $social_links ) ){
		            echo '<div class="social-contact">';
		            foreach( $social_links as $item ){
			            echo '<a href="'. esc_url( $item['url'] ) .'"><i class="'. esc_attr( $item['icon'] ) .'"></i></a>';
		            }
		            echo '</div>';
	            }
                ?>
                <?php
            }
            ?>
        </div>
    </div>
	<!--mobile menu end-->

	<!--offcanvus area start-->
    <div class="at_offcanvus_menu position-fixed">
        <button class="at-offcanvus-close"><i class="fa-solid fa-xmark"></i></button>
        <?php
        if (!empty( $canvas_logo['url']) ) {
	        echo '<a href="'. esc_url( home_url('/') ) .'" class="logo-wrapper d-inline-block mb-5"><img src="'. esc_url( $canvas_logo['url'] ).'" alt="'. esc_attr( get_bloginfo( 'name' ) ) .'"></a>';
        }
        ?>
	    <?php
	    if ( $is_contact_info == '1' ) {
            ?>
            <div class="offcanvus-content">
	            <?php
	            if ( !empty( $canvas_title ) ) {
		            echo '<h4 class="mb-4">'. esc_html( $canvas_title ) .'</h4>';
	            }
	            if ( !empty( $canvas_contents ) ) {
		            echo autohive_kses_post(wpautop($canvas_contents ));
	            }
	            if ( !empty( $canvas_btn_label ) ) {
		            echo '<a href="'.esc_url($canvas_btn_url['url']).'" class="btn btn-primary mt-4">'. esc_html( $canvas_btn_label ) .'</a>';
	            }
	            ?>
            </div>
            <div class="offcanvus-contact">
                <?php
                if ( !empty( $contact_title ) ) {
	                echo '<h4 class="mb-4 mt-5">'. esc_html( $contact_title ) .'</h4>';
                }
                ?>
                <ul class="at_canvus_address">
                    <?php
                    if ( !empty( $contact_address ) ) {
	                    echo '<li>'. esc_html( $contact_address ) .'</li>';
                    }
                    if ( !empty( $contact_number ) ) {
	                    echo '<li>'. esc_html( $contact_number ) .'</li>';
                    }
                    if ( !empty( $contact_email ) ) {
	                    echo '<li>'. esc_html( $contact_email ) .'</li>';
                    }
                    ?>
                </ul>
            </div>
		    <?php
		    // Social links
		    if ( is_array( $social_links ) ){
			    echo '<div class="at_canvus_social mt-4">';
			    foreach( $social_links as $item ){
				    echo '<a href="'. esc_url( $item['url'] ) .'" class="social-btn"><i class="'. esc_attr( $item['icon'] ) .'"></i></a>';
			    }
			    echo '</div>';
		    }
	    }
	    ?>
    </div>