<?php
/**
 * The Header Layout 1.
 *
 * @since   1.0.0
 * @package autohive
 */

$unique_id 		= uniqid( 'search-form-' );
$is_panel_on    = autohive_opt( 'is_panel_on', false );
$is_search_icon = autohive_opt( 'header_search' );
$is_cta_btn	    = autohive_opt( 'is_cta_btn' );
$top_right_text = autohive_opt('top_right_text');

//Page meta =========
$meta = get_post_meta( get_the_ID(), 'tt_page_options', true );
$is_top_header	= isset( $meta[ 'is_top_header' ] ) ? $meta[ 'is_top_header' ] : '1';
$header_type 	= isset( $meta['header_type'] ) ? $meta['header_type'] : 'box'; 
$nav_menu_bg	= $header_type == 'box' ? 'bg-white-color' : 'mb-0';
$header_class	= $header_type == 'fullwidth' ? 'header_fullwidth' : 'header_box';
$is_cta_enabled = isset( $meta['is_cta_enabled'] ) ? $meta['is_cta_enabled'] : '';
$menu_alignment	= isset( $meta['menu_alignment'] ) ? $meta['menu_alignment'] : 'ms-auto';
?>

	<header class="header-style-one header-sticky">
		<?php
		if ( $is_top_header == '1' ) { ?>
            <div class="at_topbar d-none d-sm-block bg-white">
                <div class="container">
                    <div class="row align-items-center">
	                    <?php
	                    $top_left_text = autohive_opt( 'top_left_text' );
	                    if ( !empty( $top_left_text ) ) { ?>
                            <div class="col-xl-4 col-lg-5 col-8">
                                <div class="tp-info">
                                    <p class="mb-0"><?php echo esc_html($top_left_text) ?></p>
                                </div>
                            </div>
                            <?php
	                    }
	                    ?>
                        <div class="col-xl-8 col-lg-7 col-4">
                            <div class="tp-info-wrapper d-flex align-items-center justify-content-end">
                                <?php
                                if ( !empty($top_right_text) ) {
                                    foreach ( $top_right_text as $item ) {
                                        ?>
                                        <a href="<?php echo esc_url($item['content_link']) ?>" class="d-none tp-info d-xl-inline-flex align-items-center">
                                            <span class="icon-wrapper me-2">
                                                <i class="<?php echo esc_attr($item['icon_class']) ?>"></i>
                                            </span>
                                            <p class="mb-0"><?php echo esc_html($item['content']) ?></p>
                                        </a>
                                        <?php
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			<?php 
		}
        ?>

        <div class="at_header_nav">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-6 col-lg-3">
                        <div class="logo-wrapper">
	                        <?php Autohive_Theme_Helper::branding_logo(); ?>
                        </div>
                    </div>
                    <div class="col-6 col-lg-9">
                        <div class="at_header_right d-flex align-items-center justify-content-end">

                            <nav class="at_nav_menu d-none d-lg-block">
	                            <?php
	                            if ( has_nav_menu( 'main_menu' ) ) {
		                            wp_nav_menu( array (
			                            'theme_location' => 'main_menu',
			                            'container' => null,
			                            'menu_class' => '',
			                            'walker' => new Autohive_Main_Nav_Walker(),
			                            'depth' => 3
		                            ));
	                            }
	                            else {
		                            echo '<ul><li><a target="_blank" href="' . esc_url(admin_url('nav-menus.php')) . '">' . esc_html__('Add Menu', 'autohive') . '</a></li></ul>';
	                            }
	                            ?>
                            </nav>
                            <?php
                            if ( $is_cta_btn == '1' ) {
	                            $cta_btn_label = autohive_opt('button_label');
	                            $cta_url	   = autohive_opt('button_link');
                                ?>
                                <a href="<?php echo esc_url($cta_url) ?>" class="listing-btn text-white ms-4 d-none d-sm-block">
                                    <span class="icon-wrapper d-inline-flex align-items-center justify-content-center rounded-circle text-white me-2">
                                        <i class="fa-solid fa-plus"></i>
                                    </span>
                                    <?php echo esc_html($cta_btn_label) ?>
                                </a>
                                <?php
                            }
                            ?>
                            <button class="ofcanvus-toggle header-toggle-btn ms-4 d-none d-lg-block">
                                <span></span>
                                <span></span>
                                <span></span>
                            </button>
                            <button class="mobile-menu-toggle header-toggle-btn ms-4 d-lg-none">
                                <span></span>
                                <span></span>
                                <span></span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</header>
