<?php
global $post;
$prev_post = get_previous_post();
$next_post = get_next_post();
?>
<div class="bs-post-controls mt-40">
	<div class="row align-items-center g-4 g-xxl-5">
        <?php
        //========== Previous Blog Post
        if ( !empty($prev_post) ) {
            ?>
            <div class="col-lg-6">
                <div class="post-prev d-sm-flex bs-post-item">
                    <div class="post-prev-left flex-shrink-0">
                        <a href="<?php the_permalink($prev_post->ID); ?>" class="post-control">
                            <span class="me-1"><i class="fas fa-angle-left"></i></span>
					        <?php esc_html_e('Prev Post', 'autohive'); ?>
                        </a>
                        <div class="feature-img">
                            <a href="<?php the_permalink( $prev_post->ID ); ?>">
						        <?php the_post_thumbnail($prev_post->ID); ?>
						        <?php echo get_the_post_thumbnail( $prev_post->ID, 'autohive_100x80', array( 'class' => 'rounded' ) ); ?>
                            </a>
                        </div>
                    </div>
                    <div class="post-prev-right ms-sm-3 mt-3 mt-sm-0 align-self-end">
                        <a href="<?php the_permalink($prev_post->ID); ?>" class="bs-title d-block fw-bold">
					        <?php echo get_the_title($prev_post->ID) ?>
                        </a>
                        <span class="date"><?php echo get_the_time(get_option('date_format')); ?></span>
                    </div>
                </div>
            </div>
            <?php
        }

        //========== Next Blog Post
        if ( !empty($next_post) ) {
            ?>
            <div class="col-lg-6">
                <div class="post-next d-flex flex-column flex-sm-row bs-post-item justify-content-end">
                    <div class="post-prev-left me-sm-3 mt-3 mt-sm-0 align-self-end text-end order-2 order-sm-1">
                        <a href="<?php echo get_permalink($next_post->ID) ?>" class="bs-title d-block fw-bold">
					        <?php echo get_the_title($next_post->ID) ?>
                        </a>
                        <span class="date"><?php echo get_the_time(get_option('date_format')); ?></span>
                    </div>
                    <div class="post-prev-right text-end order-1 order-sm-2">
                        <a href="<?php echo get_permalink($next_post->ID) ?>" class="post-control">
					        <?php esc_html_e('Next Post', 'autohive'); ?>
                            <span class="ms-1"><i class="fas fa-angle-right"></i></span>
                        </a>
                        <div class="feature-img">
                            <a href="<?php echo get_permalink($next_post->ID) ?>">
						        <?php echo get_the_post_thumbnail( $next_post->ID, 'autohive_100x80', array( 'class' => 'rounded' ) ); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
	</div>
</div>