<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package autohive
 */
global $post;
$sidebar 		= Autohive_Theme_Helper::render_sidebars('blog');
$row_class		= $sidebar['row_class'];
$column			= $sidebar['column'];
$category_list = get_the_category_list( ', ' );
$author = autohive_opt( 'blog_list_meta_author', true );
$meta_date = autohive_opt( 'blog_list_meta_date', false );
$meta_category = autohive_opt( 'blog_list_meta_categories', true );
$word_count = autohive_opt('word_count', '25');
$thumb_size = (isset($sidebar['content']) && !empty($sidebar['content']) ) ? 'autohive_856x400' : 'full';
?>

<div <?php post_class( 'h2-blog-card bg-white p-0' ); ?> id="post-<?php the_ID(); ?>">
    <div class="feature-img position-relative overflow-hidden w-100 rounded-top">
        <span class="btn-meta text-primary bg-white position-absolute z-2">
            <?php echo autohive_like_it_button_html(get_the_ID()) ?>
        </span>
        <?php
        if ( has_post_thumbnail() ) { ?>
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute() ?>">
		        <?php the_post_thumbnail('full', array( 'class' => 'img-fluid' )); ?>
            </a>
            <?php
        }
        ?>
    </div>
    <div class="h2-blog-card-content p-4">
        <?php
        $category_list = get_the_category_list();
        $terms    = get_the_terms( get_the_ID(), 'category' );
        $cat_temp = '';

        if ( ( $terms && ! is_wp_error( $terms ) ) && $meta_category == '1' ) {
            foreach ( $terms as $term ) {
                echo '<a href="' . get_category_link( $term->term_id ) . '" class="btn-meta" rel="category tag">' . esc_html( $term->name ) . '</a>';
	        }
        }
        ?>
        <a href="<?php the_permalink(); ?>" class="mt-3 d-block">
            <h3><?php the_title() ?></h3>
        </a>
        <p><?php echo Autohive_Theme_Helper::autohive_substring( get_the_content(), $word_count, '...' ); ?></p>
        <div class="blog-author mt-30 d-flex align-items-center">
            <?php if ( $author == '1' ) :
	            Autohive_Theme_Helper::post_author_avatar(56, '', esc_attr__('author', 'autohive'), array( 'class' => 'rounded-circle flex-shrink-0'));
            endif; ?>
            <div class="author-content ms-3">
                <h6 class="mb-1"><?php the_author_meta('display_name', $post->post_author) ?></h6>
                <?php if ( $meta_date == '1') : ?>
                    <span><?php the_time(get_option('date_format')); ?></span>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
