<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package autohive
 */

get_header();
global $post;

Autohive_Theme_Helper::set_post_views($post->ID);

$sidebar 		= Autohive_Theme_Helper::render_sidebars('blog');
$row_class		= $sidebar['row_class'];
$column			= $sidebar['column'];
$meta_category	= autohive_opt( 'blog_list_meta_categories');
$post_share_icon= autohive_opt( 'post_share_icon', false );
$video_post = has_post_format( 'video' ) ? 'video_post' : '';
$thumb_size = (isset($sidebar['content']) && !empty($sidebar['content']) ) ? 'autohive_796x372' : 'full';
$user_name = get_the_author_meta('display_name', $post->post_author );
$user_desc = get_the_author_meta( 'description', $post->post_author );
$user_email = get_the_author_meta( 'user_email', $post->post_author );
$user_facebook_url = get_the_author_meta( 'facebook', $post->post_author );
$user_twitter_url = get_the_author_meta( 'twitter', $post->post_author );
$user_linkedin_url = get_the_author_meta( 'linkedin', $post->post_author );
$user_instagram_url = get_the_author_meta( 'instagram', $post->post_author );

if ( isset( $_GET['elementor_library'] ) ) {
    while (have_posts()) : the_post();
        the_content();
        wp_link_pages(array(
            'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__('Pages:', 'autohive') . '</span>',
            'after' => '</div>',
            'link_before' => '<span>',
            'link_after' => '</span>',
            'pagelink' => '<span class="screen-reader-text">' . esc_html__('Page', 'autohive') . ' </span>%',
            'separator' => '<span class="screen-reader-text">, </span>',
        ));
    endwhile;
} else {
    ?>
    <section class="blog-list-section ptb-120">
        <div class="container">
            <div class="row">

                <div class="col-xl-<?php echo esc_attr($column) ?>">
                    <div class="blog-single-area bg-white rounded">
                        <div class="bs-blog-meta d-flex align-items-center justify-content-between">
                            <a href="<?php Autohive_Theme_Helper::the_first_category_link(); ?>" class="btn-meta fw-bold">
                                <?php Autohive_Theme_Helper::the_first_category() ?>
                            </a>
                            <span class="date"><?php the_time(get_option('date_format')); ?></span>
                        </div>
                        <h3 class="blog-title mt-3"><?php the_title() ?></h3>
                        <?php
                        if ( has_post_thumbnail() ) { ?>
                            <div class="bs-blog-thumb position-relative mt-40 mb-4">
                                <?php if ( class_exists('Autohive_Core' )) : ?>
                                    <span class="btn-meta text-primary bg-white position-absolute z-2">
                                        <?php echo autohive_like_it_button_html(get_the_ID()) ?>
                                    </span>
                                <?php endif; ?>
                                <?php the_post_thumbnail($thumb_size, array( 'class' => 'img-fluid' )); ?>
                            </div>
                            <?php
                        }

                        the_content();

                        wp_link_pages( array(
	                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'autohive' ),
	                        'after'  => '</div>',
                        ) );
                        ?>
                        <hr class="mt-40 mb-40">
                        <div class="tags-social d-flex align-items-center justify-content-between flex-wrap">
                            <?php
                            if ( has_tag() ) {
	                            Autohive_Theme_Helper::get_the_post_tag('tags-list');
                            }
                            if ( $post_share_icon == '1' ) {
                                Autohive_Theme_Helper::get_the_social_share_links();
                            }
                            ?>
                        </div>

                        <?php
                        if ( $user_name ) { ?>
                            <div class="bs-author-box mt-40 d-sm-flex align-items-center rounded">
		                        <?php Autohive_Theme_Helper::post_author_avatar(134, '', esc_attr($user_name), array( 'class' => 'rounded-circle flex-shrink-0')); ?>
                                <div class="author-box-content ms-sm-4 mt-4 mt-sm-0">
                                    <h6 class="mb-1"><?php esc_html($user_name) ?></h6>
                                    <a href="mailto:<?php echo esc_url($user_email) ?>" class="text-primary fw-semibold">
				                        <?php echo esc_html($user_email) ?>
                                    </a>
                                    <p class="mt-2 mb-3"><?php echo esc_html($user_desc) ?></p>
                                    <div class="bs-author-socials">
                                        <?php
                                        if ( !empty($user_facebook_url) ) { ?>
                                            <a href="<?php echo esc_url($user_facebook_url) ?>" class="facebook"><i class="fab fa-facebook-f"></i></a>
                                            <?php
                                        }
                                        if ( !empty($user_facebook_url) ) { ?>
                                            <a href="<?php echo esc_url($user_twitter_url) ?>" class="twitter"><i class="fab fa-twitter"></i></a>
                                            <?php
                                        }
                                        if ( !empty($user_facebook_url) ) { ?>
                                            <a href="<?php echo esc_url($user_instagram_url) ?>" class="instagram"><i class="fab fa-instagram"></i></a>
                                            <?php
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }

                        //===== Related Posts
                        get_template_part('template-parts/contents/related_posts');

                        if (comments_open() || get_comments_number()) :
	                        comments_template();
                        endif;

                        ?>
                    </div>
                </div>

	            <?php echo (isset($sidebar['content']) && !empty($sidebar['content']) ) ? $sidebar['content'] : ''; ?>


            </div>
        </div>
    </section>
    <?php
}
get_footer();