<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package autohive
 */

if ( ! function_exists( 'autohive_get_title_tag' ) ) {
	/**
	 * Returns array of title tags
	 *
	 * @param bool $first_empty
	 * @param array $additional_elements
	 *
	 * @return array
	 */
	function autohive_get_title_tag( $first_empty = false, $additional_elements = array() ) {
		$title_tag = array();

		if ( $first_empty ) {
			$title_tag[''] = esc_html__( 'Default', 'autohive' );
		}

		$title_tag['h1'] = 'h1';
		$title_tag['h2'] = 'h2';
		$title_tag['h3'] = 'h3';
		$title_tag['h4'] = 'h4';
		$title_tag['h5'] = 'h5';
		$title_tag['h6'] = 'h6';

		if ( ! empty( $additional_elements ) ) {
			$title_tag = array_merge( $title_tag, $additional_elements );
		}

		return $title_tag;
	}
}

/**
 * Preloder Callback
 */

function autohive_preloader_markup() {

    $preloader = autohive_opt('preloader_switch');
    $preloader_text = autohive_opt('preloader_text');
	$preloader_text = !empty( $preloader_text ) ? $preloader_text : get_bloginfo('name');
	$preloader_letter = str_split( $preloader_text );

    if ( $preloader == true ) {?>

		<div class="loader-wrap">
			<div class="preloader">
				<div id="handle-preloader" class="handle-preloader">
					<div class="animation-preloader">
						<div class="spinner"></div>
						<div class="txt-loading">
							<?php 
							if( is_array( $preloader_letter ) ){
								foreach( $preloader_letter as $text ){
									echo '<span data-text-preloader="'. esc_attr( $text ) .'" class="letters-loading">'. esc_html( $text ) .'</span>';
								}
							}
							?>
						</div>
					</div>
				</div>
			</div>
		</div>

        <?php
		
	}
}
add_action( 'autohive_after_body', 'autohive_preloader_markup', 1 );

// Autohive Kses Post ================
if ( ! function_exists( 'autohive_kses_post' ) ) {
    function autohive_kses_post( $content ) {
        $allowed_tag = array(
            'strong' => [],
            'p' => [],
            'span' => [
                'class' => [],
                'style' => []
            ],
            'br' => [],
            'a' => [
                'href' => [],
                'class' => [],
            ],
            'img' => [
                'src' => [],
                'srcset' => [],
                'width' => [],
                'height' => [],
                'class' => [],
                'alt' => [],
            ],
            'div' => [
                'class' => [],
                'style' => []
            ],
            'h1' => [
                'class' => [],
                'style' => []
            ],
            'h2' => [
                'class' => [],
                'style' => []
            ],
            'h3' => [
                'class' => [],
                'style' => []
            ],
            'h4' => [
                'class' => [],
                'style' => []
            ],
            'h5' => [
                'class' => [],
                'style' => []
            ],
            'h6' => [
                'class' => [],
                'style' => []
            ],
            'mark' => [
                'class' => [],
                'style' => []
            ],
        );
        return wp_kses( $content, $allowed_tag );
    }
}

// A Custom function for get an option
if ( ! function_exists( 'autohive_opt' ) ) {
	function autohive_opt( $option = '', $default = null ) {

        $options = get_option( 'autohive_cs_opt' );

		return ( isset( $options[ $option ] ) ) ? $options[ $option ] : $default;
	}
}