<?php

// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {

	//
	// Set a unique slug-like ID
	$prefix = 'tt_page_options';

	//
	// Create a metabox
	CSF::createMetabox( $prefix, array(
		'title'     => esc_html__( 'Page Option', 'autohive' ),
		'context'   => 'normal',
		'post_type' => array( 'page' ),
		'theme'     => 'dark',

	) );

	// Header Menu
	CSF::createSection( $prefix, array(
		'title'  => esc_html__( 'Header', 'autohive' ),
		'icon'   => 'fa fa-home',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Header Style', 'autohive' ),
			),
			array(
				'id'       => 'is_top_header',
				'type'     => 'switcher',
				'title'    => __( 'Top Header', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => true
			),
			array(
				'id'        => 'topbar_bg_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Topbar Background Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change topbar background color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'background'   => '.header-section .topbar, header.header-section.header-gradient.header_box:not(.sticky-header)',
				),
				'dependency'       => array( 'is_top_header', '==', true ),
			),

			array(
				'id'      => 'header_type',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Header Type', 'autohive' ),
				'options' => array(
					'box'  		=> esc_html__( 'Box', 'autohive' ),
					'fullwidth' => esc_html__( 'Full Width', 'autohive' ),
				),
				'default' => 'box'
			),

			array(
				'id'      => 'header_height',
				'type'    => 'number',
				'title'   => esc_html__( 'Header Height', 'autohive' ),
				'desc'      => esc_html__( 'Empty value will show default header height.', 'autohive' ),
				'unit'        => 'px',
				'output'      => '.header-section:not(.header_box) .header-nav',
				'output_mode' => 'height',
				'default'     => '',
			),

			array(
				'id'        => 'header_bg_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Header Background Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change header background color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'background'      => '
						.header-section .nav-menu.bg-white-color, 
						.header-section.header-gradient.header_fullwidth
					',
					
				)
			),
			
			array(
				'id'        => 'sticky_header_bg_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Sticky Header Background Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change sticky header background color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'background'      => '
						.sticky-header.header-section.header-gradient,
						.sticky-header.header-section .nav-menu.bg-white-color
					',
				)
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Logo', 'autohive' ),
			),
			array(
				'id'       => 'page_logo',
				'type'     => 'switcher',
				'title'    => __( 'Page Logo', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => true
			),
			array(
				'id'         => 'meta_main_logo',
				'type'       => 'media',
				'title'      => esc_html__( 'Logo Upload', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'desc'       => esc_html__( 'Upload logo for Header', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'id'         => 'retina_logo',
				'type'       => 'media',
				'title'      => esc_html__( 'Retina Logo Upload @2x', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'desc'       => esc_html__( 'Upload your Retina Logo. This should be your Logo in double size (If your logo is 100 x 20px, it should be 200 x 40px)', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'id'         => 'meta_sticky_logo',
				'type'       => 'media',
				'title'      => esc_html__( 'Sticky Logo', 'autohive' ),
				'desc'       => esc_html__( 'Upload logo for Header Sticky and Inner Page.', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'id'         => 'retina_logo_sticky',
				'type'       => 'media',
				'title'      => esc_html__( 'Sticky Retina Logo @2x', 'autohive' ),
				'desc'       => esc_html__( 'Upload Retina logo for Header Sticky.', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Header Menu Style', 'autohive' ),
			),

			array(
				'id'      => 'menu_alignment',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Menu Alignment', 'autohive' ),
				'options' => array(
					'me-auto'	=> esc_html__( 'Left', 'autohive' ),
					'm-auto'	=> esc_html__( 'Center', 'autohive' ),
					'ms-auto'	=> esc_html__( 'Right', 'autohive' ),
				),
				'default' => 'ms-auto'
			),

			array(
				'id'     => 'menu_color',
				'type'   => 'color',
				'title'  => esc_html__( 'Menu Text Color', 'autohive' ),
				'desc'   => esc_html__( 'You can change menu text color.', 'autohive' ),
				'output' => array(
					'color' => '
						.nav-wrapper nav > ul > li > a,
						.nav-wrapper ul li.has-submenu::after,
						.header-right div.ofcanvus-btns a,
						.header-right div.next a::before
					',
					'fill'	=> '.header-right div svg path'
				),
				// 'output_important' => true
			),
			array(
				'id'        => 'menu_color_hover',
				'type'      => 'color',
				'title'     => esc_html__( 'Menu Text Hover Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change menu text hover color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'color'      => '
						.nav-wrapper nav > ul > li:hover > a,
						.nav-wrapper ul li:hover>a,
						.nav-wrapper ul li.has-submenu:hover::after,
						.header-right div.ofcanvus-btns a:hover
					',
					'fill' 		=> '.header-right div svg:hover path'
					
				)
			),
			array(
				'id'     => 'menu_color_dropdown',
				'type'   => 'color',
				'title'  => esc_html__( 'Menu Dropdown Text Color', 'autohive' ),
				'desc'   => esc_html__( 'You can change menu text color.', 'autohive' ),
				'output' => '.nav-wrapper ul li.has-submenu .submenu-wrapper li a'
			),

			array(
				'id'     => 'menu_color_hover_dropdown',
				'type'   => 'color',
				'title'  => esc_html__( 'Menu Dropdown Text Hover Color', 'autohive' ),
				'desc'   => esc_html__( 'You can change menu text hover color.', 'autohive' ),
				'output' => array(
					'color' => '.nav-wrapper ul li.has-submenu .submenu-wrapper li a:hover',
				)
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Header Sticky Menu Style', 'autohive' ),
			),

			array(
				'id'               => 'sticky_menu_color',
				'type'             => 'color',
				'title'            => esc_html__( 'Menu Text Color', 'autohive' ),
				'desc'             => esc_html__( 'You can change menu text color.', 'autohive' ),
				'output_important' => true,
				'output' => [
					'color' => '
						.header-section.sticky-header .nav-wrapper ul li a,
						.header-section.sticky-header .nav-wrapper ul li.has-submenu::after,
						.header-section.sticky-header .header-right div.ofcanvus-btns a,
						.header-section.sticky-header .header-right div.next a::before
					',
					'fill'	=> '.header-section.sticky-header .header-right div svg path'

				]
			),

			array(
				'id'               => 'sticky_menu_color_hover',
				'type'             => 'color',
				'output_important' => true,
				'title'            => esc_html__( 'Menu Text Hover Color', 'autohive' ),
				'desc'             => esc_html__( 'You can change menu text hover color.', 'autohive' ),
				'add_title'        => esc_html__( 'Upload', 'autohive' ),
				'output'           => array(
					'color' => '
						.header-section.sticky-header .nav-wrapper ul li a:hover,
						.header-section.sticky-header .nav-wrapper ul li.has-submenu:hover::after,
						.header-section.sticky-header .header-right div.ofcanvus-btns a:hover,
						.header-section.sticky-header .header-right div.next a:hover::before
					',
					'fill'	=> '.header-section.sticky-header .header-right div svg:hover path'

				)
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Call To Action', 'autohive' ),
			),
			array(
				'id'       => 'is_cta_enabled',
				'type'     => 'switcher',
				'title'    => __( 'Call To Action', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => false
			),
			array(
				'id'          => 'select_btn_style',
				'type'        => 'select',
				'title'       => __('Select Button Style', 'autohive' ),
				'options'	  => [
					'btn-primary'	=> __('Primary', 'autohive'),
					'btn-secondary' => __('Secondary', 'autohive'),
					'btn-success' 	=> __('Success', 'autohive'),
					'btn-danger' 	=> __('Danger', 'autohive'),
					'btn-warning' 	=> __('Warning', 'autohive'),
					'btn-info' 		=> __('Info', 'autohive'),
					'btn-light' 	=> __('Light', 'autohive'),
					'btn-dark' 		=> __('Dark', 'autohive'),
					'primary-btn'=> __('Theme Primary', 'autohive'),
					'gm-header-btn'=> __('Buttom Gaming', 'autohive'),
				],
				'default' => 'primary-btn',
				'dependency' => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'id'       => 'cta_btn',
				'type'     => 'link',
				'title'    => 'Call To Action Button',
				'default'  => array(
					'url'    => '#',
					'text'   => 'Get Started',
					'target' => '_blank'
				),
				'dependency'       => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'type'    => 'subheading',
				'content' => esc_html__( '- Button Normal Style', 'autohive' ),
			),
			array(
				'id'     => 'cta_btn_color',
				'type'   => 'color',
				'title'  => esc_html__( 'Button Color', 'autohive' ),
				'output' => array(
					'color' => '.header-right .template-btn'
				),
				'dependency'       => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'id'     => 'cta_btn_bg',
				'type'   => 'background',
				'title'  => esc_html__( 'Button Background Color', 'autohive' ),
				'background_gradient'  => true,
				'background_image'     => false,
				'background_position'  => false,
				'background_size'      => false,
				'background_repeat'    => false,
				'background_attachment'=> false,
				'output'			   => '.header-right .template-btn',
				'dependency'           => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'id'     => 'cta_btn_border',
				'type'   => 'border',
				'title'  => esc_html__( 'Border', 'autohive' ),
				'output' => '.header-right .template-btn',
				'dependency'       => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'id'          => 'cta_btn_padding',
				'type'        => 'spacing',
				'title'       => __( 'Padding', 'autohive' ),
				'output'      => '.header-right .template-btn',
				'output_mode' => 'padding',
				'dependency'  => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'type'    => 'subheading',
				'content' => esc_html__( '- Button Hover Style', 'autohive' ),
			),
			array(
				'id'     => 'cta_btn_color_hover',
				'type'   => 'color',
				'title'  => esc_html__( 'Button Color', 'autohive' ),
				'output' => array(
					'color' => '.header-right .template-btn:hover'
				),
				'dependency'       => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'id'     => 'cta_btn_bg_hover',
				'type'   => 'background',
				'title'  => esc_html__( 'Button Background Color', 'autohive' ),
				'background_gradient'  => true,
				'background_image'     => false,
				'background_position'  => false,
				'background_size'      => false,
				'background_repeat'    => false,
				'background_attachment'=> false,
				'output' => ['.header-right .template-btn:hover', '.primary-btn::before'],
				'dependency'       => array( 'is_cta_enabled', '==', true ),
			),
			array(
				'id'     => 'cta_btn_border_hover',
				'type'   => 'border',
				'title'  => esc_html__( 'Border', 'autohive' ),
				'output' => '.header-right .template-btn:hover',
				'dependency'       => array( 'is_cta_enabled', '==', true ),
			),
			

		)
		
	) );

	// Page Header
	CSF::createSection( $prefix, array(
		'title'  => 'Page Header',
		'icon'   => 'fa fa-picture-o',
		'fields' => array(

			array(
				'id'      => 'meta_page_header',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Page Header Option', 'autohive' ),
				'options' => array(
					'default'  => esc_html__( 'Default', 'autohive' ),
					'enabled'  => esc_html__( 'Enabled', 'autohive' ),
					'disabled' => esc_html__( 'Disabled', 'autohive' ),
				),
				'default' => 'default'
			),

			array(
				'id'               => 'header_image',
				'type'             => 'background',
				'title'            => esc_html__( 'Header Image', 'autohive' ),
				'desc'             => esc_html__( 'Default: Featured image, if fail will get image from global settings.', 'autohive' ),
				'dependency'       => array( 'meta_page_header', '==', 'enabled' ),
				'output'           => '.page-header',
				'output_important' => true,
			),

			array(
				'id'         => 'custom_title',
				'type'       => 'text',
				'title'      => esc_html__( 'Custom Title', 'autohive' ),
				'desc'       => esc_html__( 'Set custom title for the page header. Default: The post title.', 'autohive' ),
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
			),

			array(
				'id'         => 'meta_page_header_description',
				'type'       => 'textarea',
				'title'      => esc_html__( 'Page Description', 'autohive' ),
				'desc'       => esc_html__( 'Set custom title for the page header. Default: The post title.', 'autohive' ),
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
			),

			array(
				'id'         => 'custom_title_typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'Title Typography', 'autohive' ),
				'output'     => '.page-banner .page-title',
				'dependency' => array( 'page_header', '==', 'enabled' ),
			),
			array(
				'id'         => 'custom_title_color',
				'type'       => 'color',
				'title'      => esc_html__( 'Title Color', 'autohive' ),
				'output'     => '.page-banner .page-title',
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
			),

			array(
				'id'         => 'breadcrumbs',
				'type'       => 'switcher',
				'title'      => esc_html__( 'Header Breadcrumbs', 'autohive' ),
				'desc'       => esc_html__( 'Display breadcrumbs on the page header', 'autohive' ),
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
				'default'    => true,
			),

		),
	) );

	// Footer Menu
	CSF::createSection( $prefix, array(
		'title'  => esc_html__( 'Footer', 'autohive' ),
		'icon'   => 'fa fa-home',
		'fields' => array(

			array(
				'id'       => 'meta_footer_type',
				'type'     => 'switcher',
				'title'    => __( 'Footer Style', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => false
			),

			array(
				'id'          => 'meta_footer_style',
				'type'        => 'select',
				'title'       => __('Select Footer Style', 'autohive' ),
				'options'     => Autohive_Theme_Helper::get_post_list( 'autohive_footer' ),
				'dependency' => array( 'meta_footer_type', '==', 'true' ),
			),

			array(
				'id'         => 'meta_footer_color',
				'type'       => 'button_set',
				'title'      => __( 'Switch Footer Dark or Light', 'autohive' ),
				'options'    => array(
					'footer_dark'  => __( 'Dark', 'autohive' ),
					'footer_light' => __( 'Light', 'autohive' ),
				),
				'default'    => 'footer_dark',
				'dependency' => array( 'meta_footer_type', '==', 'true' ),
			),

			array(
				'id'          => 'meta_footer_padding_top',
				'type'        => 'spacing',
				'title'       => __( 'Padding Top', 'autohive' ),
				'output'      => '.site-footer .footer-wrapper',
				'output_mode' => 'padding', //
				'left'        => false,
				'right'       => false,
				'dependency'  => array( 'meta_footer_type', '==', 'true' ),
			),
		)
	) );
}