<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {


	// Set a unique slug-like ID
	$prefix = 'listing_rent_meta';


	// Create a metabox - Dealer Listing
	CSF::createMetabox($prefix, array(
		'title'     => __('Listing Rent Info', 'autohive'),
		'post_type' => 'autohive_rent',
		'data_type' => 'unserialize'
	));


	// Create a section - General Info
	CSF::createSection($prefix, array(
		'title'  => esc_html__('General Info', 'autohive'),
		'icon'  => esc_html__('', 'autohive'),
		'fields' => array(

			array(
				'id'      => 'featured',
				'type'    => 'checkbox',
				'title'   => esc_html__('Featured Agent', 'autohive'),
			),
			array(
				'id'      => 'daily_rent',
				'type'    => 'text',
				'title'   => esc_html__('Rent Daily', 'autohive'),
				'default' => '$150'
			),
			array(
				'id'      => 'monthly_rent',
				'type'    => 'text',
				'title'   => esc_html__('Rent Monthly', 'autohive'),
				'default' => '$3900'
			),

		)
	));


	// Create a section - Dealer Information
	CSF::createSection($prefix, array(
		'title'  => esc_html__(' Information', 'autohive'),
		'icon'  => esc_html__('', 'autohive'),
		'fields' => array(
			array(
				'id'        => 'vehicle_type',
				'type'      => 'button_set',
				'title'     => 'Vehicle Type',
				'options'   => array(
					'car'	=> 'New Car',
					'motor' => 'Motor Bike',
				),
				'default'    => 'car'
			),
			
			array(
				'id'          => 'pickup_loacation',
				'type'        => 'select',
				'title'       => __('Car Pickup Location', 'autohive'),
				'after' 	  => __('If Pickup Location field is empty then you have to add Pickup Location from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::car_pickup_location(),

			),

			array(
				'id'      => 'pickup_date',
				'type'    => 'datetime',
				'title'   => esc_html__('Pickup Date & Time', 'autohive'),
				'settings' => array(
					'enableTime' => true,
				),
				'default' => '12/24/2022 12:28 PM'
			),

			array(
				'id'          => 'return_loacation',
				'type'        => 'select',
				'title'       => __('Car Return Location', 'autohive'),
				'after' 	  => __('If Pickup Location field is empty then you have to add Pickup Location from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::car_pickup_location(),

			),

			array(
				'id'      => 'return_date',
				'type'    => 'datetime',
				'title'   => esc_html__('Return Date & Time', 'autohive'),
				'settings' => array(
					'enableTime' => true,
				),
				'default' => '12/25/2022 12:00 PM'
			),

			array(
				'id'          => 'car_bodytype',
				'type'        => 'select',
				'title'       => __('Select Body Type', 'autohive'),
				'after' 	  => __('If body type field is empty then you have to add body type from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::listing_body_type(),

			),

			array(
				'id'      => 'mileage',
				'type'    => 'text',
				'title'   => esc_html__('Mileage', 'autohive'),
				'default' => '70,000 (Mi)'
			),

			array(
				'id'      => 'car_transmissions',
				'type'    => 'text',
				'title'   => esc_html__('Car Transmissions', 'autohive'),
				'default' => 'Manual'
			),

			array(
				'id'      => 'car_engine_size',
				'type'    => 'text',
				'title'   => esc_html__('Car Engine Size', 'autohive'),
				'default' => '120cc'
			),

			array(
				'id'      => 'fuel_type',
				'type'    => 'text',
				'title'   => esc_html__('Fuel Type', 'autohive'),
				'default' => 'Petrol'
			),


			array(
				'id'      => 'build_year',
				'type'    => 'number',
				'title'   => esc_html__('Build Year', 'autohive'),
				'default' => '2017'
			),

			array(
				'id'      => 'drivetrian',
				'type'    => 'text',
				'title'   => esc_html__('Drivetrian', 'autohive'),
				'default' => 'Front Wheel'
			),

			array(
				'id'      => 'car_color',
				'type'    => 'text',
				'title'   => esc_html__('Car Color', 'autohive'),
				'default' => __('Black', 'autohive')
			),
			array(
				'id'      => 'cylinders',
				'type'    => 'text',
				'title'   => esc_html__('Engine Cylinders', 'autohive'),
				'default' => '6'
			),
			array(
				'id'      => 'car_vin',
				'type'    => 'text',
				'title'   => esc_html__('VIN', 'autohive'),
				'default' => __('1C4TJPBA1CD', 'autohive')
			),
			array(
				'id'      => 'car_doors',
				'type'    => 'text',
				'title'   => esc_html__('Doors', 'autohive'),
				'default' => __('2 Doors', 'autohive')
			),
			array(
				'id'      => 'passengers',
				'type'    => 'text',
				'title'   => esc_html__('Passengers', 'autohive'),
				'default' => __('06', 'autohive')
			),
			array(
				'id'      => 'suitcase',
				'type'    => 'text',
				'title'   => esc_html__('Suitcase', 'autohive'),
				'default' => __('1 Large, 2 Small', 'autohive')
			),



		)
	));
}
