<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Set a unique slug-like ID
    $prefix = 'auto_parts_meta';


    // Create a metabox - Listing Manager
    CSF::createMetabox($prefix, array(
        'title'     => __('Auto Parts Meta', 'autohive'),
        'post_type' => 'product',
        'data_type' => 'unserialize'
    ));


    // Create a section - Features
    CSF::createSection($prefix, array(
        'title'  => esc_html__('Product Meta', 'autohive'),
        'icon'  => esc_html__('', 'autohive'),
        'fields' => array(

            array(
                'id'      => 'carModel',
                'type'    => 'text',
                'title'   => esc_html__('Car Model', 'autohive'),
                'default' => esc_html__('Hyundai Tucson', 'autohive'),
            ),

            array(
                'id'      => 'buildYear',
                'type'    => 'number',
                'title'   => esc_html__('Build Year', 'autohive'),
                'default' => '2017'
            ),

            array(
                'id'      => 'partsNumber',
                'type'    => 'text',
                'title'   => esc_html__('Parts Number', 'autohive'),
                'default' => ''
            ),

        )
    ));
}
