<?php
//Social Link
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Contact Info', 'autohive' ),
	'icon'   => 'fa fa-address-card-o',
	'desc'   => esc_html__( 'This social profiles will display in your whole site.', 'autohive' ),
	'fields' => array(
		array(
			'type'    => 'subheading',
			'content' => esc_html__( 'Contact Info', 'autohive' ),
		),
		array(
			'id'      => 'is_contact_info',
			'type'    => 'switcher',
			'title'   => 'Contact Info',
			'label'   => 'Do you want activate it ?',
			'default' => false
		),

		array(
			'type'    => 'media',
			'title'   => esc_html__( 'Canvas Logo', 'autohive' ),
			'id'      => 'canvas_logo',
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),

		array(
			'type'    => 'text',
			'title'   => esc_html__( 'Canvas Title', 'autohive' ),
			'id'      => 'canvas_title',
			'default' => esc_html__( 'About Us', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),

		array(
			'type'    => 'wp_editor',
			'title'   => esc_html__( 'Canvas Contents', 'autohive' ),
			'id'      => 'canvas_contents',
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),
		array(
			'type'    => 'text',
			'title'   => esc_html__( 'Button Label', 'autohive' ),
			'id'      => 'canvas_btn_label',
			'default' => esc_html__( 'Contact Info', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),
		array(
			'type'    => 'link',
			'title'   => esc_html__( 'Button URL', 'autohive' ),
			'id'      => 'canvas_btn_url',
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),

		array(
			'type'    => 'text',
			'title'   => esc_html__( 'Contact Title', 'autohive' ),
			'id'      => 'contact_title',
			'default' => esc_html__( 'Contact Info', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),
		array(
			'type'    => 'text',
			'title'   => esc_html__( 'Contact Address', 'autohive' ),
			'id'      => 'contact_address',
			'default' => esc_html__( 'Chicago 12, Melborne City, USA', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),
		array(
			'type'    => 'text',
			'title'   => esc_html__( 'Phone Number', 'autohive' ),
			'id'      => 'contact_phone',
			'default' => esc_html__( '+88 01682648101', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),

		array(
			'type'    => 'text',
			'title'   => esc_html__( 'Email', 'autohive' ),
			'id'      => 'contact_email',
			'default' => esc_html__( 'info@themetags.com', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),

		array(
			'type'    => 'subheading',
			'content' => esc_html__( 'Social links', 'autohive' ),
			'dependency' => array( 'is_contact_info', '==', 'true' )
		),
		array(
			'id'           => 'social_links',
			'type'         => 'group',
			'title'        => esc_html__( 'Social links', 'autohive' ),
			'desc'         => esc_html__( 'This social profiles will display in your whole site.', 'autohive' ),
			'button_title' => esc_html__( 'Add New', 'autohive' ),
			'dependency'   => array( 'is_contact_info', '==', 'true' ),
			'fields'       => array(

				array(
					'id'    => 'name',
					'type'  => 'text',
					'title' => esc_html__( 'Name', 'autohive' ),
				),
				array(
					'id'    => 'url',
					'type'  => 'text',
					'title' => esc_html__( 'Url', 'autohive' )
				),
				array(
					'id'    => 'icon',
					'type'  => 'icon',
					'title' => esc_html__( 'Icon', 'autohive' )
				)

			),

			'default' => array(
				array(
					'name' => esc_html__( 'Facebook', 'autohive' ),
					'url'  => esc_url( 'http://facebook.com' ),
					'icon' => 'fab fa-facebook-f'
				),

				array(
					'name' => esc_html__( 'Twitter', 'autohive' ),
					'url'  => esc_url( 'http://twitter.com' ),
					'icon' => 'fab fa-twitter'
				),

				array(
					'name' => esc_html__( 'Dribbble', 'autohive' ),
					'url'  => esc_url( 'http://dribbble.com' ),
					'icon' => 'fab fa-dribbble'
				)

			),
			array(
				'type'    => 'notice',
				'class'   => 'info',
				'content' => esc_html__( 'This social profiles will display in your whole site.', 'autohive' ),
			),
		),
	)
) );