<?php
//Page Header
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Page Header', 'autohive' ),
	'icon'   => 'fa fa-picture-o',
	'fields' => array(

		array(
			'type'    => 'subheading',
			'content' => esc_html__( ' Page Header Settings', 'autohive' ),
		),
		array(
			'id'      => 'page_header',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Page Header Enable', 'autohive' ),
			'default' => true,
		),

		array(
			'id'      => 'banner_height',
			'type'    => 'slider',
			'title'   => __( 'Banner Height', 'autohive' ),
			'min'     => 250,
			'max'     => 600,
			'step'    => 1,
			'unit'    => 'px',
			'default' => 325,
			'output'  => [
				'min-height' => '.breadcrumb-area',
			]
		),

		array(
			'id'     => 'custom_title_typography',
			'type'   => 'typography',
			'title'  => esc_html__( 'Title Typography', 'autohive' ),
			'output' => array(
				'color' => '.breadcrumb-content h2',
			),
		),
		array(
			'id'                    => 'page_header_image',
			'type'                  => 'background',
			'title'                 => esc_html__( 'Header Background', 'autohive' ),
			'desc'                  => esc_html__( 'Default: Featured image, if fail will get image from global settings.', 'autohive' ),
			'output'                => '.breadcrumb-area',
			'background_gradient'   => true,
			'background_origin'     => true,
			'background_clip'       => true,
			'background_blend_mode' => true,
			'default'               => array(
				'background-gradient-direction' => 'to right',
				'background-size'               => 'cover',
				'background-position'           => 'center center',
				'background-repeat'             => 'no-repeat',
			),
		),
	)
) );