<?php
// General Setting
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'General', 'autohive' ),
	'icon'   => 'fa fa-building-o',
	'fields' => array(
		array(
			'id'    => 'preloader_switch',
			'type'  => 'switcher',
			'title' => esc_html__( 'Enable Preloader', 'autohive' ),
		),
		array(
			'id'      => 'preloader_text',
			'type'    => 'text',
			'title'   => esc_html__( 'Pre-loader Text', 'autohive' ),
			'default' => 'Autohive',
			'dependency' => array( 'preloader_switch', '==', 'true' ),
		),
		array(
			'id'         => 'preloader_color',
			'title'      => esc_html__( 'Preloader Text Color', 'autohive' ),
			'type'       => 'color',
			'output'	 => '.handle-preloader .animation-preloader .txt-loading .letters-loading',
			'dependency' => array( 'preloader_switch', '==', 'true' ),
		),
		array(
			'id'                              => 'preload_bar_bg',
			'type'                            => 'background',
			'title'                           => 'Preload Bar Background',
			'background_gradient'             => true,
			'background_blend_mode'           => false,
			'background_image'				  => false,
			'background_size'				  => false,
			'background_attachment'			  => false,
			'background_position'			  => false,
			'background_repeat'				  => false,
			'output'						  => '.handle-preloader .animation-preloader .spinner',
			'dependency' => array( 'preloader_switch', '==', 'true' ),
		),
		array(
			'id'      => 'back_to_top',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Display Back To Top Button', 'autohive' ),
			'default' => true
		),

		array(
			'id'       => 'custom-css',
			'type'     => 'code_editor',
			'title'    => 'CSS Editor',
			'settings' => array(
				'theme' => 'mbo',
				'mode'  => 'css',
			),
			'default'  => '.element{ color: #ffbc00; }',
		)
	)
) );