<?php
//Color Scheme
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Color Scheme', 'autohive' ),
	'icon'   => 'fa fa-paint-brush',
	'fields' => array(

		array(
			'type'    => 'subheading',
			'content' => esc_html__( 'General Color', 'autohive' ),
		),

		array(
			'id'     => 'body-color',
			'type'   => 'color',
			'title'  => esc_html__( 'Body Color', 'autohive' ),
			'output' => 'body'
		),

		array(
			'id'     => 'main_heading-color',
			'type'   => 'color',
			'title'  => esc_html__( 'Heading Color', 'autohive' ),
			'output' => 'h1,h2,h3,h4,h5,h6, .blog-content .entry-title a',
		),

		array(
			'id'     => 'main_primary_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Primary Color', 'autohive' ),
			'desc'   => esc_html__( 'Main Color Scheme', 'autohive' ),
			'output' => array(
				'color'            => '.topbar .topbar-right a:hover, .nav-wrapper ul li:hover::after, .nav-wrapper ul li:hover>a,
						.lang-switcher ul li a:hover, .header-two .nav-wrapper ul li.has-submenu .submenu-wrapper li .menu-list-wrapper .icon-wrapper,
						.header-two .nav-wrapper ul li.has-submenu .submenu-wrapper .megamenu-item .menu-list-wrapper .icon-wrapper,
						.footer-widget .footer-nav li a:hover, .footer-widget .footer-nav li a:hover::before, .footer-copyright .copyright-links a:hover,
						.h5-footer-address li i,.outline-primary,.cd-secondary-btn, .handle-preloader .animation-preloader .txt-loading .letters-loading,
						.promo-item .promo-top span,.pricing-column .pricing-label,.pricing-column .feature-list li i,.service-card:hover .card-content a,
						.blog-card .blog-content-wrapper h3:hover,.blog-card .blog-content-wrapper h4:hover,.blog-card .blog-content h3:hover,
						.blog-card .blog-content h4:hover,.hm2-explore-btn,.hm2-feature-card .icon-wrapper,.hm2-server-tab-control li button i,
						.hm2-app-item .app-content h3:hover,.hm2-app-item .app-content a:hover,.clients-explore .app-info h6,.hm2-blog-card .hm2-blog-card-content h3:hover,
						.categories-widget ul li a:hover,.categories-widget ul li a:hover::after,.recent-post-widget ul.rs-news-list li .rs-news-content h6:hover,
						.archive-widget .archive-list li a:hover,.bd-content-wrapper .bd-rl-post-wrapper h6:hover,.sh-feature-list ul li i,.wp-pricing-meta-item .wp-icon-wrapper,
						.wp-feature-item .icon-wrapper,.vps_pp_feature_item h6 span,.vps-pricing-table table tbody tr td i,.vps-tab-info p a,.ds-pricing-item .ds-pricing-list li span,
						.hosting-info-title mark,.home4-about-accordion .accordion-item .accordion-header a::before,.h4-blog-card .h4-blog-content h3:hover,
						.h5-service-box h4:hover,.h5-service-box a.explore:hover,.h5-service-box:hover a.explore,.h5-blog-card .h5-blog-article-content h4:hover,
						.h5-blog-card .h5-blog-article-content .share-btn:hover,.h5-blog-card .h5-blog-article-content .explore-btn:hover,.bf-pricing-btn-meta,
						.bd-blog-meta span:hover h6,.bd-blog-meta span:hover a,.bd-blog-meta span:hover,.hm2-blog-card-content .bog-author span:hover h6,
						.hm2-blog-card-content .bog-author span:hover a,.hm2-blog-card-content .bog-author span:hover,.sidebar-widget ul li a:hover,
						.widget_categories ul li a:hover,.widget_categories ul li a:hover::after,.sidebar-widget ol.wp-block-latest-comments .wp-block-latest-comments__comment a:hover,
						.autohive_blog_content>ul li a:hover,.breadcrumb-area nav ol li a:hover',

				'background' => '.nav-wrapper ul li.has-submenu .submenu-wrapper li .menu-list-wrapper .icon-wrapper,
						.nav-wrapper ul li.has-submenu .submenu-wrapper .megamenu-item .menu-list-wrapper .icon-wrapper, .header-search-form,
						.header-style-4 .sh-header-cart button .number,.hm2-sb-form .radio-btns input:checked~label span::before,
						.cd-secondary-btn:hover,.blog-card .feature-thumb .category-btn,.hm2-feature-card a:hover,.hm2-service-tab ul li button::after,
						.hm2-server-tab-control li button::before,.slider-pagination span.swiper-pagination-bullet-active::before,.vps-pricing-table table tbody tr td a:hover,
						.vps_scripts_slider_wrapper .vps-scripts-slider .swiper-control-btn:hover,.signup-form-wrapper form input[type=submit],.ds-faq-controls li button.active,
						.h5-service-box .icon-wrapper::before,.h5-pricing-controls li a.active,.h5-pricing-filter-controls li a::before,.h5-feedback .h5-feedback-slider .swiper-controls',

				'background-color'	   => '.outline-btn:hover,.secondary-btn:hover, .outline-primary:hover,.hm2-feature-card:hover .icon-wrapper,.hm2-feature-card:hover a,
						.map-location .ct-location li,.h5-feedback .h5-feedback-slider .swiper-next:hover,.pricing-plan-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active::before,
						.em-pricing-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active::before',

				'border-color'	   => '.outline-btn:hover,.outline-primary,.hm2-feature-card a:hover,.hm2-feature-card:hover a,.slider-pagination span.swiper-pagination-bullet-active,
						.vps-pricing-table table tbody tr td a, .pricing-plan-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active,
						.em-pricing-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active',
			),
		),

		array(
			'id'     => 'theme_gradient_color',
			'type'   => 'background',
			'title'  => esc_html__( 'Theme Gradient Color', 'autohive' ),
			'background_gradient'  => true,
			'background_image'     => false,
			'background_position'  => false,
			'background_size'      => false,
			'background_repeat'    => false,
			'background_attachment'=> false,
			'output'			   => [
				'background' => '
						.template-pagination ul.page-numbers li .page-numbers::after,.wp-block-quote.has-text-align-right:after,
						.sidebar-widget form button, .sidebar-widget form button::before, .sidebar-widget .wp-block-group__inner-container h1::before,.sidebar-widget .wp-block-group__inner-container h2::before,
						.sidebar-widget .wp-block-group__inner-container h3::before,.sidebar-widget .wp-block-group__inner-container h4::before,.sidebar-widget .wp-block-group__inner-container h5::before,
						.sidebar-widget .wp-block-group__inner-container h6::before, .footer-widget .ft-subtitle::after, .footer-widget .widget-title::before,.footer-widget .social-nav li a,
						.footer-widget .social-nav li a::before, .hm2-footer-copyright .footer-social a::before, .primary-btn,.scrolltop-btn,.hm2-title mark,.template-pagination ul li a:after,
						.handle-preloader .animation-preloader .spinner, .tab-switch-btn .toggle-switch-btn::before,.money-back-area .money-back_ft-list li i,.hm2-explore-btn::before,
						.hm2-service-tab ul li button.active i,.hm2-pricing-tab>ul li button.active,.hm2-pricing-single .pricing-badge span,.hm2-pricing-bottom ul li i,.hm2-server-content .server-info .explore-btn,
						.hm2-feedback-item .quote-icon,.hm2-blog-card .hm2-blog-card-content .tag-btn::before,.sidebar-widget .widget-title::before,.bd-content-wrapper blockquote::before,
						.bd-content-wrapper blockquote .bd-quote-author::before,.hm-ct-info-wrapper .icon-wrapper,.sh-benefits-wrapper .icon-wrapper i,.sh-benefits-wrapper .icon-wrapper::before,
						.cp-accordion .accordion-single::after, .dm-pp-domain-item::before,.dm-support-info a i,.vps-pricing-table table thead tr th,.vps-video-box::before, .vps-feature-btns li a::before,
						.ds-faq-controls li button::before,.home4-about-accordion .accordion-item .accordion-header a:not(.collapsed)::before,.h5-tab-controls li a::after,.friday-hosting-offer .primary-btn,
						.em-pricing-single-item .em-pricing-btn
					',
			]
		),

		array(
			'id'     => 'theme_gradient_hover',
			'type'   => 'background',
			'title'  => esc_html__( 'Theme Gradient Hover Color', 'autohive' ),
			'background_gradient'  => true,
			'background_image'     => false,
			'background_position'  => false,
			'background_size'      => false,
			'background_repeat'    => false,
			'background_attachment'=> false,
			'output'			   => [
				'background' => '
						.primary-btn::before, .footer-widget .social-nav li a::before,.wp-hero .wp-hero-dot-illustration,.hero-4 .hero4-circle,.em-pricing-single-item .em-pricing-btn::before,
						.hm2-blog-card .hm2-blog-card-content .tag-btn,.sidebar-widget form button::before
					',
			]
		),

		array(
			'id'     => 'link-color',
			'type'   => 'link_color',
			'title'  => 'Link Color',
			'color'  => true,
			'hover'  => true,
			'focus'  => true,
			'output' => '.post .author a, .product .author a, 
				.post .blog-content .read-more, .post .blog-content .post-meta li a:hover,
				.product .blog-content .read-more'
		),


	)
) );