<?php
//Blog Setting
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Blog', 'autohive' ),
	'icon'   => 'fa fa-file-text-o',
	'fields' => array(

		array(
			'id'         => 'blog_style',
			'type'       => 'image_select',
			'title'      => esc_html__( 'Style', 'autohive' ),
			'desc'       => esc_html__( 'Display number of post per row', 'autohive' ),
			'radio'      => true,
			'options'    => array(
				'list' => AUTOHIVE_DIR_IMG . '/layout/list.png',
				'grid' => AUTOHIVE_DIR_IMG . '/layout/grid.png',
			),
			'default'    => 'list',
		),

		array(
			'id'         => 'blog_column',
			'type'       => 'image_select',
			'title'      => esc_html__( 'Columns', 'autohive' ),
			'desc'       => esc_html__( 'Display number of post per row', 'autohive' ),
			'radio'      => true,
			'options'    => array(
				'6' => AUTOHIVE_DIR_IMG . '/layout/2cols.png',
				'4' => AUTOHIVE_DIR_IMG . '/layout/3cols.png',
			),
			'default'    => '6',
		),

		array(
			'id'      => 'blog_sidebar_layout',
			'type'    => 'image_select',
			'title'   => esc_html__( 'Layout', 'autohive' ),
			'radio'   => true,
			'options' => array(
				'left'       => AUTOHIVE_DIR_IMG . '/layout/left-sidebar.png',
				'no-sidebar' => AUTOHIVE_DIR_IMG . '/layout/no-sidebar.png',
				'right'      => AUTOHIVE_DIR_IMG . '/layout/right-sidebar.png',
			),
			'default' => 'right',
		),

		array(
			'id'       => 'blog_sidebar_def_width',
			'type'     => 'button_set',
			'title'    => esc_html__( 'Blog Archive Sidebar Width', 'autohive' ),
			'options'  => array(
				'9' => '25%',
				'8' => '33%',
			),
			'default'  => '8',
			'required' => array( 'blog_sidebar_layout', '!=', 'none' ),
		),

		array(
			'id'       => 'blog_sidebar_gap',
			'type'     => 'select',
			'title'    => esc_html__( 'Blog Archive Sidebar Side Gap', 'autohive' ),
			'options'  => array(
				'def' => 'Default',
				'0'   => '0',
				'15'  => '15',
				'20'  => '20',
				'25'  => '25',
				'30'  => '30',
				'35'  => '35',
				'40'  => '40',
				'45'  => '45',
				'50'  => '50',
			),
			'default'  => '15',
			'required' => array( 'blog_sidebar_layout', '!=', 'none' ),
		),

		array(
			'id'      => 'word_count',
			'type'       => 'text',
			'title'      => esc_html__( 'Post Content Word Count', 'autohive' ),
			'default'    => 20,
			'dependency' => array( 'blog_style', '==', 'list' ),
		),

		array(
			'id'      => 'word_count_grid',
			'type'       => 'text',
			'title'      => esc_html__( 'Post Content Word Count', 'autohive' ),
			'default'    => 7,
			'dependency' => array( 'blog_style', '==', 'grid' ),
		),

		array(
			'id'      => 'author_info',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Display Author Bio Box', 'autohive' ),
			'default' => false
		),

		array(
			'id'      => 'blog_list_meta_author',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Hide post-meta author?', 'autohive' ),
			'default' => true,
		),
		array(
			'id'      => 'blog_list_meta_categories',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Hide post-meta categories?', 'autohive' ),
			'default' => true,
		),
		array(
			'id'      => 'blog_list_meta_date',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Hide post-meta date?', 'autohive' ),
			'default' => false,
		),

		array(
			'type'    => 'subheading',
			'content' => esc_html__( ' Single Post', 'autohive' ),
		),

		array(
			'id'      => 'single_post_nav',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Hide Post Navigation?', 'autohive' ),
			'default' => false,
		),

		array(
			'id'      => 'post_share_icon',
			'type'    => 'switcher',
			'title'   => esc_html__( 'Show post share icon', 'autohive' ),
			'default' => false,
		),

	)
) );