<?php
/**
 * Add Image Size
 */
add_image_size('autohive_856x400', 856, 400, true); //Blog List Post Image Size
add_image_size('autohive_796x372', 796, 372, true); //Blog Single Post Image Size
add_image_size('autohive_100x80', 100, 80, true); //Blog Related Next/Prev Image Size
add_image_size('autohive_306x245', 306, 245, true); // WooCommerce - Product Grid Thumbnails
add_image_size('autohive_70x70', 70, 70, true); // WooCommerce - Product Recent, Popular Post


/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function autohive_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'main-sidebar' ) ) {
		$classes[] = 'no-sidebar';
	}


	return $classes;
}
add_filter( 'body_class', 'autohive_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function autohiveo_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'autohiveo_pingback_header' );

/**
 * Filter the categories archive widget to add a span around post count
 */
function autohive_cat_count_span($links) {
	$links = str_replace('</a> ', ' <sup class="post-count">', $links);
	$links = str_replace(')', ')</sup></a>', $links);
	return $links;
}
add_filter('wp_list_categories', 'autohive_cat_count_span');

/**
 * Filter the archives widget to add a span around post count
 */
function autohive_archive_count_span($links) {
	$links = str_replace('</a>&nbsp;(', ' <span class="post-count">(', $links);
	$links = str_replace(')', ')</span></a>', $links);
	return $links;
}
add_filter('get_archives_link', 'autohive_archive_count_span');

/**
 * Codestar Framework Welcome page disable
 */
add_filter( 'csf_welcome_page', '__return_false' );

/**
 * Comment Form Rearrange
 */
if (!function_exists('autohive_reorder_comment_fields')) {
	function autohive_reorder_comment_fields($fields ) {
		$new_fields = array();

		$myorder = array('author', 'email', 'url', 'comment');

		foreach( $myorder as $key ){
			$new_fields[ $key ] = isset($fields[ $key ]) ? $fields[ $key ] : '';
			unset( $fields[ $key ] );
		}

		if( $fields ) {
			foreach( $fields as $key => $val ) {
				$new_fields[ $key ] = $val;
			}
		}

		return $new_fields;
	}
}

add_filter('comment_form_fields', 'autohive_reorder_comment_fields');


// Remove <p> and <br/> from Contact Form 7
add_filter('wpcf7_autop_or_not', '__return_false');


/*Contact form 7 remove span*/
add_filter('wpcf7_form_elements', function($content) {
	$content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

	$content = str_replace('<br />', '', $content);

	return $content;
});


/**
 * @param $class
 * Get Comment reply link class
 * @return array|string|string[]
 */
function autohive_comment_reply_link_class( $class ) {
	$class = str_replace( "class='comment-reply-link", "class='comment-reply-link reply-btn", $class );
	return $class;
}

add_filter( 'comment_reply_link', 'autohive_comment_reply_link_class' );

/**Comment field wrapper row */
function autohive_comment_form_before(){
	echo '<div class="row g-3">';
}
add_action( 'comment_form_top', 'autohive_comment_form_before' );


/**Comment field wrapper row end */
function autohive_comment_form_after(){
	echo '</div>';
}
add_action( 'comment_form', 'autohive_comment_form_after' );
