<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Autohive Theme Support
 *
 *
 * @class        Autohive_Theme_Support
 * @version      1.0
 * @category     Class
 * @author       ThemeTags
 */

if ( ! class_exists( 'Autohive_Theme_Support' ) ) {
	class Autohive_Theme_Support {

		private static $instance = null;

		public static function get_instance() {
			if ( null == self::$instance ) {
				self::$instance = new self();
			}

			return self::$instance;
		}

		public function __construct() {

			//Register Nav Menu
			add_action( 'init', array( $this, 'autohive_register_nav_menus' ) );

			//Add translation file
			add_action( 'init', array( $this, 'autohive_enqueue_translation_files' ) );

			//Add widget support
			add_action( 'widgets_init', array( $this, 'register_sidebar_widgets' ) );

			add_action( 'after_setup_theme', array( $this, 'autohive_setup' ) );
			add_action( 'after_switch_theme', [ $this, 'autohive_add_cpt_support' ] );

			add_theme_support( 'align-wide' );
			add_theme_support( 'wp-block-styles' );
			add_theme_support( "responsive-embeds" );
			add_theme_support( 'editor-styles' );
			add_editor_style( 'style-editor.css' );
		}

		function autohive_setup() {

			add_theme_support( 'post-thumbnails' );
			set_post_thumbnail_size( 770, 465, array( 'center', 'center' ) ); // Hard crop center center

			add_theme_support( 'automatic-feed-links' );
			add_theme_support( 'revisions' );
			add_theme_support( 'title-tag' );
			add_theme_support( 'post-formats', array( 'gallery', 'video', 'quote', 'audio', 'link' ) );
			add_theme_support( 'html5', array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption'
			) );

			add_theme_support( 'woocommerce' );

			// Set up the WordPress core custom background feature.
			add_theme_support( 'custom-background', apply_filters( 'autohive_custom_background_args', array(
				'default-color' => 'ffffff',
				'default-image' => '',
			) ) );

			/**
			 * Add support for core custom logo.
			 *
			 * @link https://codex.wordpress.org/Theme_Logo
			 */
			add_theme_support( 'custom-logo', array(
				'height'      => 50,
				'width'       => 200,
				'flex-width'  => true,
				'flex-height' => true,
			) );


			/**
			 * Set the content width in pixels, based on the theme's design and stylesheet.
			 *
			 * Priority 0 to make it available to lower priority callbacks.
			 *
			 * @global int $content_width
			 */
			$GLOBALS['content_width'] = apply_filters( 'content_width', 1170 );
		}

		public function autohive_register_nav_menus() {
			register_nav_menus(
				array(
					'main_menu' => esc_html__( 'Main Menu', 'autohive' ),
				)
			);
		}

		public function autohive_enqueue_translation_files() {
			load_theme_textdomain( 'autohive', get_template_directory() . '/languages/' );
		}

		public function register_sidebar_widgets() {

			// Default wrapper for widget and title
			$wrapper_before = '<div id="%1$s" class="widget sidebar-widget %2$s">';
			$wrapper_after  = '</div>';
			$title_before   = '<h3 class="widget-title">';
			$title_after    = '</h3>';

			//==== Blog Sidebar
			register_sidebar( array(
				'name'          => esc_html__( 'Primary Sidebar', 'autohive' ),
				'id'            => 'sidebar_widgets',
				'description'   => esc_html__( 'Add widget here to appear it in sidebar.', 'autohive' ),
				'before_widget' => $wrapper_before,
				'after_widget'  => $wrapper_after,
				'before_title'  => $title_before,
				'after_title'   => $title_after,
			));

			//==== Shop Sidebar
			if ( class_exists('WooCommerce') ) {
				register_sidebar( array(
					'name'          => esc_html__( 'Shop Sidebar', 'autohive' ),
					'id'            => 'shop_sidebar',
					'description'   => esc_html__( 'Place widgets here for WooCommerce shop page.', 'autohive' ),
					'before_widget' => '<div id="%1$s" class="shop-sidebar-widget bg-white py-4 px-3 mb-4 %2$s">',
					'after_widget'  => '</div>',
					'before_title'  => '<h3 class="widget-title">',
					'after_title'   => '</h3>',
				));
			}

		}

		/**
		 * Enable default Elementor Editor for custom post type.
		 */
		public function autohive_add_cpt_support() {
			//if exists, assign to $cpt_support var.
			$cpt_support = get_option( 'elementor_cpt_support' );

			//check if option DOESN'T exist in db.
			if ( ! $cpt_support ) {
				// Create array of our default supported post types.
				$cpt_support = [
					'page',
					'post',
					'portfolio',
				];
				update_option( 'elementor_cpt_support', $cpt_support );

			} else {

				if ( ! in_array( 'portfolio', $cpt_support ) ) {
					$cpt_support[] = 'portfolio';
				}

				update_option( 'elementor_cpt_support', $cpt_support );
			}
		}

	}

	new Autohive_Theme_Support();
}