<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * @class        Autohive_Enqueue_Script
 * @version      1.0
 * @category     Class
 * @author       ThemeTags
 */
class Autohive_Enqueue_Script {

    public $settings;
    protected static $instance = null;
    private $gtdu;

    public static function instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Return the Google font stylesheet URL if available.
     *
     * The use of Libre Franklin by default is localized. For languages that use
     * characters not supported by the font, the font can be disabled.
     *
     * @return string Font stylesheet or empty string if disabled.
     * @since autohive 1.2
     *
     */
    public function autohive_get_font_url() {

	    $fonts_url = '';
	    $fonts     = array();
	    $subsets   = '';

	    /* Body font */
	    if (  'off' !== 'on'  ) {
		    $fonts[] = "Plus Jakarta Sans:300,400,500,600,700,800";
	    }

	    $is_ssl = is_ssl() ? 'https' : 'http';

	    if ( $fonts ) {
		    $fonts_url = add_query_arg( array(
			    'family' => urlencode( implode( '|', $fonts  ) ),
			    'subset' => urlencode( $subsets ),
		    ), "$is_ssl://fonts.googleapis.com/css" );
	    }

	    return $fonts_url;
    }


    public function register_script() {
        $this->gtdu = get_template_directory_uri();

        // Register Frontend Scripts
        add_action('wp_enqueue_scripts', array($this, 'css_register'));
        add_action('wp_enqueue_scripts', array($this, 'js_register'));

		//Register Admin Scripts
		add_action('admin_enqueue_scripts', array($this, 'admin_css_register'));
    }

    /* Register CSS */
    public function css_register() {

	    /**
	     * Register Style File's
	     */
	    wp_register_style('swiper', $this->gtdu . '/assets/vendors/swiper/swiper.min.css');
	    wp_register_style('autohive-shop', $this->gtdu . '/assets/css/shop.css', array(), wp_get_theme()->get('Version'));



	    $font_url = $this->autohive_get_font_url();
	    if (!empty($font_url)) {
		    wp_enqueue_style('autohive-fonts', esc_url_raw($font_url), array(), null);
	    }

	    wp_enqueue_style('autohive-blog', $this->gtdu . '/assets/css/blog.css');

	    wp_enqueue_style('bootstrap', $this->gtdu . '/assets/vendors/bootstrap/css/bootstrap.min.css');
        wp_enqueue_style('fontawesome', $this->gtdu . '/assets/vendors/font-awesome/all.min.css');
        wp_enqueue_style('flaticon', $this->gtdu . '/assets/vendors/flaticon/style.css');
        wp_enqueue_style('autohive-main', $this->gtdu . '/assets/css/app.css');
        wp_enqueue_style('autohive-root', get_stylesheet_uri(), array(), wp_get_theme()->get('Version'));


		// WooCommerce Plugin Check
		if ( class_exists( 'WooCommerce') ) {
			if ( is_shop() || is_checkout() || function_exists('is_wishlist') && is_wishlist()  ) {
				wp_enqueue_style('swiper');
				wp_enqueue_style('autohive-shop');
			}
		}

		// YITH Plugin Check
	    if ( class_exists('YITH_WCWL') ) {
		    wp_enqueue_style('autohive-shop');
	    }


	    // Inline CSS
	    $dynamic_css = '';

		if ( class_exists('CSF') ) {

			// Page Title Bar Banner
			$banner_img = autohive_opt('banner_bg_img');
			$banner_img_url = $banner_img['url'];
			if ( !empty($banner_img_url) ) {
				$dynamic_css .= "
		            .breadcrumb-section {
		                background: url($banner_img_url) no-repeat center;
		            }
		        ";
			}
		}

	    wp_add_inline_style( 'autohive-root', $dynamic_css);

    }

    /* Register JS */
    public function js_register() {


	    /**
	     * Register Scripts File
	     */
	    wp_register_style('swiper', $this->gtdu . '/assets/vendors/swiper/swiper.min.js');


	    /**
	     * Enqueue Scripts File
	     */
        wp_enqueue_script('popper', $this->gtdu . '/assets/vendors/bootstrap/js/popper.min.js', ['jquery'], '2.9.2', true);
        wp_enqueue_script('bootstrap', $this->gtdu . '/assets/vendors/bootstrap/js/bootstrap.min.js', ['jquery'], '5.2.0', true);
        wp_enqueue_script('autohive-script', $this->gtdu . '/assets/js/app.js', array('jquery'), wp_get_theme()->get('Version'), true);

		// WooCommerce Scripts
	    if ( class_exists( 'WooCommerce') && is_woocommerce() ) {
		    wp_enqueue_script('swiper');
		    wp_enqueue_script('autohive-shop', $this->gtdu . '/assets/js/shop.js', array('jquery'), wp_get_theme()->get('Version'), true);
	    }

        // Comment Reply
        if (is_singular() && comments_open() && get_option('thread_comments')) {
            wp_enqueue_script('comment-reply');
        }
    }

    public function admin_css_register() {
        wp_enqueue_style('admin-font-awesome-five', $this->gtdu . '/assets/css/all.min.css');
    }

}

if (!function_exists('autohive_enqueue_script')) {
    function autohive_enqueue_script() {
        return Autohive_Enqueue_Script::instance();
    }
}

autohive_enqueue_script()->register_script();