<?php
/**
 * autohive functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package autohive
 */
/**
 * Constants
 * Defining default asset paths
 */
define( 'AUTOHIVE_THEME_DIR', get_template_directory() ); //Theme Root File
define('AUTOHIVE_DIR_IMG', get_template_directory_uri() . '/assets/images' );
define('AUTOHIVE_DIR_FONT', get_template_directory_uri() . '/assets/fonts' );

/**
 * Implement the Custom Header feature.
 */
require AUTOHIVE_THEME_DIR . '/inc/custom-header.php';

/**
 * Load All Classes.
 */
require_once AUTOHIVE_THEME_DIR . '/inc/class/theme-autoload.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require AUTOHIVE_THEME_DIR . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require AUTOHIVE_THEME_DIR . '/inc/customizer.php';


/**
 * WordPress Hooks files
 */
require AUTOHIVE_THEME_DIR . '/inc/filter_hooks.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require AUTOHIVE_THEME_DIR . '/inc/jetpack.php';
}

/**
 * WooCommerce Helper Functions
 */
if ( class_exists('woocommerce') ) {
	require AUTOHIVE_THEME_DIR . '/inc/woo/woo_config.php';
}