;(function($) {
    // Strict Mode
    'use strict';

    $(document).ready(function () {

        //Product Single Related Product
        const rlProductSlider = new Swiper(".rl-products-slider", {
            slidesPerView: 4,
            spaceBetween: 24,
            loop: true,
            autoplay: true,
            navigation: {
                nextEl: '.slider-button-next',
                prevEl: '.slider-button-prev'
            },
            breakpoints: {
                0: {
                    slidesPerView: 1
                },
                576: {
                    slidesPerView: 2,
                    spaceBetween: 16
                },
                992: {
                    slidesPerView: 3,
                    spaceBetween: 24
                },
                1400: {
                    slidesPerView: 4
                }
            }
        });


        // Product Quantity decrement "--"
        $('.product-qty .decrement').on("click", function () {

            let getID = $(this).next().attr("id");
            let result = document.getElementById(getID);
            let qty = result.value;

            if (!isNaN(qty) && qty > 0) {
                result.value--;
                $('.single_add_to_cart_button').attr('data-quantity', result.value )
            } else {
                return false;
            }

        });


        // Product Quantity Increment "++"
        $('.product-qty .increment').on("click", function () {

            let getID = $(this).prev().attr("id");
            let result = document.getElementById(getID);
            let qty = result.value;

            if (!isNaN(qty)) {
                result.value++;
                $('.single_add_to_cart_button').attr('data-quantity', result.value )
            } else {
                return false;
            }

        });


    })

})(jQuery);