;(function($) {
    // Strict Mode
    'use strict';

    $(document).ready(function () {


        $(window).on('scroll', function () {
            //header sticky
            var scrollBar = $(this).scrollTop();

            if (scrollBar > 100) {
                $(".header-sticky").addClass("sticky-on");
            } else {
                $(".header-sticky").removeClass("sticky-on");
            } //theme scroll-top button

            if (scrollBar > 300) {
                $(".theme-scrolltop-btn").fadeIn();
            } else {
                $(".theme-scrolltop-btn").fadeOut();
            } //vertical listing menu

            var scrollBarPosition = $(window).scrollTop();
            $(".car_listing_nav ul li a").each(function () {
                var navOffset = $(this.hash).offset().top - 120;

                if (scrollBarPosition > navOffset) {
                    $(this).parents("ul").find("a.active").removeClass("active");
                    $(this).addClass("active");
                }
            });
        });

        function offCanvus() {
            $(".ofcanvus-toggle").on("click", function () {
                $(".at_offcanvus_menu").addClass("active");
            });
            $(".at-offcanvus-close").on("click", function () {
                $(".at_offcanvus_menu").removeClass("active");
            });
            $(document).on("mouseup", function (e) {
                var offCanvusMenu = $(".at_offcanvus_menu");

                if (!offCanvusMenu.is(e.target) && offCanvusMenu.has(e.target).length === 0) {
                    $(".at_offcanvus_menu").removeClass("active");
                }
            });
        }

        offCanvus(); //mobile menu

        $(".mobile-menu-toggle").on("click", function () {
            $(".mobile-menu").addClass("active");
        });
        $(".mobile-menu .close-menu").on("click", function () {
            $(".mobile-menu").removeClass("active");
        });
        $(".mobile-menu ul li.has-submenu a").each(function () {
            $(this).on("click", function () {
                $(this).siblings('ul').slideToggle();
                $(this).toggleClass("icon-rotate");
            });
        });
        $(document).on("mouseup", function (e) {
            var offCanvusMenu = $(".mobile-menu");

            if (!offCanvusMenu.is(e.target) && offCanvusMenu.has(e.target).length === 0) {
                $(".mobile-menu").removeClass("active");
            }
        });


        //custom scrollbar
        var at_scrollbar = $(".at_scrollbar");
        if ( at_scrollbar.length > 0 ) {
            $(".at_scrollbar").mCustomScrollbar({
                axis: "y"
            });    
        }

        // Custom Rating with commnet form
        var logID = 'log',
            log = $('<div id="' + logID + '"></div>');
        $('body').append(log);
        $('[type*="radio"]').change(function () {
            var me = $(this);
            log.html(me.attr('value'));
        });
        
    })

})(jQuery);