<?php
/**
 * Additional Information tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/additional-information.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$heading = apply_filters( 'woocommerce_product_additional_information_heading', __( 'Specification', 'autohive' ) );

?>
<div class="description-tab-box bg-white pt-40 pb-40 px-4 rounded" id="specification">
	<?php if ( $heading ) : ?>
        <h5 class="mb-30"><?php echo esc_html( $heading ); ?></h5>
	<?php endif; ?>
    <h6 class="py-3 px-4 rounded bg-color"><?php esc_html_e('Basic Information', 'autohive'); ?></h6>
	<?php do_action( 'woocommerce_product_additional_information', $product ); ?>
</div>
