<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
$sku = ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'autohive' );

if ( $related_products ) : ?>
    <section class="related products related-products pb-120">
        <div class="container overflow-hidden pt-3">
	        <?php
	        $heading = apply_filters( 'woocommerce_product_related_products_heading', __( 'Related products', 'autohive' ) );
	        if ( $heading ) : ?>
                <div class="row">
                    <div class="col-lg-8">
                        <div class="section-title text-center text-md-start">
                            <h3 class="mb-0"><?php echo esc_html( $heading ); ?></h3>
                        </div>
                    </div>
                </div>
	        <?php endif; ?>

            <div class="rl-products-slider swiper mt-40 overflow-visible">
                <div class="swiper-wrapper">

	                <?php woocommerce_product_loop_start(); ?>

	                <?php
                    foreach ( $related_products as $related_product ) :

		                $post_object = get_post( $related_product->get_id() );

		                setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

                        ?>
                        <div class="h4-ft-product-card bg-white rounded  swiper-slide">
                            <div class="product-card-top position-relative overflow-hidden">
		                        <?php
		                        if ( !empty($product->get_sale_price()) ) { ?>
                                    <span class="discount-badge position-absolute fw-500 z-1"><?php autohive_show_sale_percentage_loop() ?></span>
			                        <?php
		                        }
		                        if ( class_exists('YITH_WCWL') ) {
			                        echo do_shortcode('[yith_wcwl_add_to_wishlist]');
		                        }
		                        the_post_thumbnail('autohive_306x245', array( 'class' => 'img-fluid feature-img' ));
		                        ?>
                                <div class="at_product_action position-absolute start-50 translate-middle-x z-1">
			                        <?php

			                        woocommerce_template_loop_add_to_cart();

			                        if ( shortcode_exists('yith_quick_view') ) {
				                        echo do_shortcode('[yith_quick_view]');
			                        }

			                        if ( class_exists('TT_Compare_Products') && shortcode_exists('tt_compare_button') ) {
				                        echo do_shortcode('[tt_compare_button product_id="'.get_the_ID().'"]');
			                        }
			                        ?>
                                </div>
                            </div>
                            <div class="product-card-bottom mt-4">
                                <div class="product-rating mb-1">
			                        <?php autohive_the_woo_product_ratting() ?>
                                </div>
                                <a href="<?php the_permalink(); ?>" class="product-title" title="<?php the_title_attribute() ?>">
	                                <?php echo wp_trim_words(get_the_title(), 8, '') ?>
                                </a>
                                <div class="product-pricing mt-2">
			                        <?php woocommerce_template_loop_price() ?>
                                </div>
                            </div>
                        </div>
                        <?php
                    endforeach;
                    ?>

	                <?php woocommerce_product_loop_end(); ?>

                </div>
                <div class="slider-button-next flash-controls" tabindex="0" role="button" aria-label="Next slide" aria-controls="swiper-wrapper"><i class="fa-solid fa-angle-right"></i></div>
                <div class="slider-button-prev flash-controls" tabindex="0" role="button" aria-label="Previous slide" aria-controls="swiper-wrapper"><i class="fa-solid fa-angle-left"></i></div>
                <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
            </div>
        </div>
    </section>
	<?php
endif;

wp_reset_postdata();
