<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

$column = wc_get_loop_prop( 'columns' );
switch ($column) {
    case '3':
        $col = '4';
        break;
    case '4':
        $col = '3';
        break;
    case '2':
        $col = '6';
        break;
    default:
        $col = '4';
        break;
}

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$sku = ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'autohive' );
?>
<div <?php wc_product_class( 'col-lg-'.$col.' col-sm-6', $product ); ?>>

    <div class="h4-ft-product-card bg-white rounded">
        <div class="product-card-top position-relative overflow-hidden">
            <?php
            if ( !empty($product->get_sale_price()) ) { ?>
                <span class="discount-badge position-absolute fw-500 z-1"><?php autohive_show_sale_percentage_loop() ?></span>
                <?php
            }
            if ( class_exists('YITH_WCWL') ) {
	            echo do_shortcode('[yith_wcwl_add_to_wishlist]');
            }
            the_post_thumbnail('autohive_306x245', array( 'class' => 'img-fluid feature-img' ));
            ?>

            <div class="at_product_action position-absolute start-50 translate-middle-x z-1">
                <?php

                woocommerce_template_loop_add_to_cart();

                if ( shortcode_exists('yith_quick_view') ) {
	                echo do_shortcode('[yith_quick_view]');
                }
                if ( class_exists('TT_Compare_Products') && shortcode_exists('tt_compare_button') ) {
	                echo do_shortcode('[tt_compare_button product_id="'.get_the_ID().'"]');
                }
                ?>
            </div>
        </div>
        <div class="product-card-bottom mt-4">
            <div class="product-rating mb-1">
	            <?php autohive_the_woo_product_ratting() ?>
            </div>
            <a href="<?php the_permalink(); ?>" class="product-title" title="<?php the_title_attribute() ?>">
                <?php echo wp_trim_words(get_the_title(), 8, '') ?>
            </a>
            <div class="product-pricing mt-2">
                <?php woocommerce_template_loop_price() ?>
            </div>
        </div>
    </div>
</div>
