<?php

/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined('ABSPATH') || exit;

do_action('woocommerce_before_mini_cart'); ?>

<?php if (!is_null(WC()->cart) && !WC()->cart->is_empty()) { ?>
	<div class="widget_shopping_cart_content">
		<ul class=" woocommerce-mini-cart cart_list product_list_widget ">
			<?php
			do_action('woocommerce_before_mini_cart_contents');

			foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
				$_product   = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
				$product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

				if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
					$product_name      = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
					$thumbnail         = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
					$product_price     = apply_filters('woocommerce_cart_item_price', WC()->cart->get_product_price($_product), $cart_item, $cart_item_key);
					$product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);

			?>
					<li class="d-flex align-items-center woocommerce-mini-cart-item <?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>">
						<div class="thumb-wrapper">
							<a href="<?php echo esc_url($product_permalink) ?>">
								<?php echo autohive_kses_post($thumbnail) ?>
							</a>
						</div>
						<div class="items-content ms-3">
							<a href="<?php echo esc_url($product_permalink) ?>">
								<h6 class="mb-1"><?php echo esc_html($product_name) ?></h6>
							</a>
							<div class="products_meta">
								<?php echo apply_filters('woocommerce_widget_cart_item_quantity', '<span class="price text-primary fw-semibold">' . $product_price . '</span>') ?>
								<?php echo wc_get_formatted_cart_item_data($cart_item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped 
								?>
								<span class="count ms-2">x <?php echo esc_html($cart_item['quantity']) ?></span>
							</div>
						</div>
						<?php echo apply_filters(
							'woocommerce_cart_item_remove_link',
							sprintf(
								'<a href="%s" class="remove_cart_btn remove remove_from_cart_button" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"><i class="fa-solid fa-trash-can"></i></a>',
								esc_url(wc_get_cart_remove_url($cart_item_key)),
								esc_attr__('Remove this item', 'autohive'),
								esc_attr($product_id),
								esc_attr($cart_item_key),
								esc_attr($_product->get_sku())
							),
							''
						);
						?>
					</li>
			<?php
				}
			}

			do_action('woocommerce_mini_cart_contents');
			?>
		</ul>

		<div class="d-flex align-items-center justify-content-between mt-3 woocommerce-mini-cart__total total">
			<h6 class="mb-0"><?php esc_html_e('Subtotal:', 'autohive'); ?></h6>
			<span class="fw-semibold text-primary"><?php echo (WC()->cart->get_cart_subtotal()) ?></span>
		</div>

		<?php do_action('woocommerce_widget_shopping_cart_before_buttons'); ?>

		<a href="<?php echo wc_get_checkout_url() ?>" class="btn btn-primary btn-md d-block mt-20">
			<span class="me-2"><i class="fa-solid fa-wallet"></i></span>
			<?php esc_html_e('Checkout', 'autohive'); ?>
		</a>

		<?php do_action('woocommerce_widget_shopping_cart_after_buttons'); ?>
	</div>
<?php
} else { ?>

	<p class="woocommerce-mini-cart__empty-message"><?php esc_html_e('No products in the cart.', 'autohive'); ?></p>

<?php
}
?>

<?php do_action('woocommerce_after_mini_cart');
