<?php

/**
 * Template for displaying page header
 */

$page_header       = autohive_opt('page_header', true);
$page_header_img   = autohive_opt('page_header_image');
$page_header_title = autohive_opt('page_header_default_title');
$page_header_crumb = autohive_opt('page_breadcrumbs', true);
$support_signle_title = autohive_opt('support_single_title', true);
$description = autohive_opt('page_header_description');

$banner_display       = true;
$banner_image      = '';
$banner_title      = get_the_title();
$banner_crumb      = false;
$banner_des_enable = true;
$banner_description = $description;


if (isset($page_header)) {
	$banner_display = $page_header;
}

if ($page_header_crumb == true) {
	$banner_crumb = true;
}

if (is_404()) {
	$banner_display = false;
	$banner_crumb = false;
}


if (!empty($page_header_title)) {
	$banner_title = $page_header_title;
}



if (is_singular()) {

	if (is_singular('post')) {

		if (!empty($page_signle_title)) {
			$banner_title = $page_signle_title;
		} else {
			$banner_title = get_the_title();
		}
	} else {
		global $post;
		$meta = get_post_meta($post->ID, 'tt_page_options', true);
		if (is_array($meta)) {

			if (!empty($meta['custom_title'])) {
				$banner_title = $meta['custom_title'];
			} elseif (get_post_type(get_the_ID()) == 'post') {
				$banner_title = esc_html__('Blog', 'autohive');
			} elseif (is_page()) {
				$banner_title = get_the_title($post->ID);
			} else {
				$post_type    = get_post_type_object(get_post_type());
				$banner_title = $post_type->labels->singular_name;
			}

			if ($meta['meta_page_header'] == 'disabled') {
				$banner_display = false;
			} elseif ($meta['meta_page_header'] == 'enabled') {
				$banner_display = true;
			}

			if (!empty($meta['header_image'])) {
				$banner_image = wp_get_attachment_url($meta['header_image']);
			}

			if ($meta['breadcrumbs'] == false) {
				$banner_crumb = false;
			}

			if (!empty($meta['meta_page_header_description'])) {
				$banner_description = $meta['meta_page_header_description'];
			}
		}
	}
} elseif (is_search()) {
	if (have_posts()) {
		$banner_title = sprintf(esc_html__('Search Results for: %s', 'autohive'), '<span>' . get_search_query() . '</span>');
	} else {
		$banner_title = sprintf(esc_html__('Search Results for: %s', 'autohive'), '<span>' . get_search_query() . '</span>');
	}
}
elseif (class_exists('WooCommerce') && is_shop()) {
	$banner_title = __('Shop', 'autohive');
}
elseif (is_archive()) {
	$banner_title = get_the_archive_title();
} elseif (is_home() && !is_front_page()) {
	$postId       = get_option('page_for_posts');
	$banner_title = esc_html__('Blog', 'autohive');

	if (!empty($postId)) {
		$meta = get_post_meta($postId, 'tt_page_options', true);
		if (!empty($meta['custom_title'])) {
			$banner_title = $meta['custom_title'];
		} else {
			$banner_title = get_the_title($postId);
		}
	}
} elseif (is_page()) {
	$banner_title = get_the_title();
} elseif (is_404()) {
	$banner_title = esc_html__('404', 'autohive');
} else {
	$banner_title = esc_html__('Blog', 'autohive');
}

if ($banner_display == false) {
	return;
}

$banner_shape1_opt = autohive_opt('banner_shape1');
$banner_shape2_opt = autohive_opt('banner_shape2');

if (!is_singular('product')) { ?>

	<section class="breadcrumb-section position-relative z-2 overflow-hidden mt--75">
		<?php
		if (!empty($banner_shape1_opt['url'])) { ?>
			<img src="<?php echo esc_url($banner_shape1_opt['url']) ?>" alt="<?php esc_html_e('banner-shape', 'autohive'); ?>" class="position-absolute start-0 z-1 tire-print">
		<?php
		}
		if (!empty($banner_shape2_opt['url'])) { ?>
			<img src="<?php echo esc_url($banner_shape2_opt['url']) ?>" alt="<?php esc_html_e('banner-shape', 'autohive'); ?>" class="position-absolute end-0 z-1 tire-print">
		<?php
		}
		?>
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<?php
					if (is_singular('post') && has_category()) { ?>
						<div class="cat_wrapper tags-list mb-30 justify-content-center">
							<?php Autohive_Theme_Helper::autohive_entry_cat('category', 'template-btn primary-btn'); ?>
						</div>
					<?php
					}
					?>
					<div class="breadcrumb-content-wrapper text-center position-relative z-3">
						<h1 class="text-white"><?php echo wp_kses_post($banner_title); ?></h1>
						<?php Autohive_Breadcrumb::breadcrumb('justify-content-center') ?>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
}

if (is_singular('product') ) { ?>
	<section class="breadcrumb-section product_single_breadcrumb position-relative z-2 overflow-hidden mt--75">
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<div class="breadcrumb-content-wrapper position-relative z-3">
						<?php Autohive_Breadcrumb::breadcrumb('justify-content-start') ?>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php
} ?>