<?php

/**
 * The template for displaying all single Listing Item
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package autohive
 */

get_header();
global $post;

Autohive_Theme_Helper::set_post_views($post->ID);

$carLoacation   = get_post_meta(get_the_ID(), 'car_loacation', true);
$dailyRent      = get_post_meta(get_the_ID(), 'daily_rent', true);
?>
<!--hero banner start-->
<div class="cr-hero-banner">
    <?php the_post_thumbnail('full') ?>
</div>
<!--hero banner end-->

<!--car info-->
<section class="car-info">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="car-info-box bg-white rounded d-flex flex-wrap align-items-center justify-content-between">
                    <div class="info-left">
                        <h3><?php the_title() ?></h3>
                        <?php
                        if (!empty($carLoacation)) {
                            echo '<span class="location"><i class="fa-solid fa-location-dot"></i>' . esc_html($carLoacation) . '</span>';
                        }
                        if (!empty($dailyRent)) {
                            echo '<span class="pricing text-primary d-block fw-bold mt-4">' . esc_html($dailyRent) . '/<span>Per Day</span></span>';
                        }
                        ?>


                    </div>
                    <div class="right-btns d-flex flex-wrap align-items-center mt-30 mt-md-0 position-relative">
                        <a href="#" data-url="<?php the_permalink() ?>" class="link_copy"><i class="fa-regular fa-copy"></i></a>
                        <?php echo autohive_like_it_button_html(get_the_ID(), false) ?>
                        <a href="#" class="page_print"><i class="fa-solid fa-print"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<div class="rental-description">
    <?php the_content(); ?>
</div>

<?php
get_footer();
