<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package autohive
 */

get_header();

$sidebar = Autohive_Theme_Helper::render_sidebars();
$column = $sidebar['column']; ?>

<section class="blog-list-section ptb-120">
    <div class="container">
        <div class="row">
            <div class="col-xl-<?php echo esc_attr($column); ?>">
                <div class="blog-list-wrapper overflow-hidden">
                    <?php
                    if (have_posts()) { ?>
                        <div class="row g-4">

                            <?php
                            while (have_posts()) {
                                the_post();
                                get_template_part('template-parts/contents/content');
                            }
                            ?>

                        </div>

                        <?php
                        Autohive_Theme_Helper::autohive_post_pagination();
                    } else { ?>
                        <div class="search_page_404_wrapper">
                            <div class="search-header-404">
                                <h2 class="page-title"><?php esc_html_e('Nothing Found', 'autohive'); ?></h2>
                            </div>

                            <div class="autohive-page-content">
                                <?php if (is_search()) : ?>
                                    <p class="banner_404_text">
                                        <?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'autohive'); ?>
                                    </p>
                                    <div class="search_result_form text-center">
                                        <?php get_search_form(); ?>
                                    </div>
                                    <div class="tt_home_button">
                                        <a class="template-btn primary-btn" href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Back to Home', 'autohive'); ?></a>
                                    </div>
                                <?php else : ?>
                                    <p class="banner_404_text">
                                        <?php esc_html_e('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'autohive'); ?>
                                    </p>
                                    <div class="search_result_form text-center">
                                        <?php get_search_form(); ?>
                                    </div>

                                    <div class="tt_404_button ">
                                        <a class="template-btn primary-btn me-4" href="<?php echo esc_url(home_url('/')); ?>"><?php esc_html_e('Back to Home', 'autohive'); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php
                    } ?>

                </div>
            </div>
            <?php echo (isset($sidebar['content']) && !empty($sidebar['content'])) ? $sidebar['content'] : ''; ?>
        </div>
    </div>
</section>

<?php

get_footer();
