<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Autohive
 * @since 1.0
 * @version 1.0
 */

get_header();
the_post();

$sidebar = Autohive_Theme_Helper::render_sidebars();
$row_class = $sidebar['row_class'];
$column = $sidebar['column'];


$wrap_class = 'page_wrapper';

if ( class_exists('WooCommerce') ) {
    if ( is_cart() ) {
		$wrap_class = 'shopping-cart';
	}
    if ( is_checkout() ) {
		$wrap_class = 'checkout-section';
	}
	if ( function_exists('is_wishlist') ) {
		if ( is_wishlist() ) {
			$wrap_class = 'wishlist-section';
		}
	}
}
?>
<div class="content-area <?php echo esc_attr($wrap_class) ?> pt-120 pb-120">
    <div class="container">
        <?php
        the_content();

        wp_link_pages(array(
            'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'autohive' ) . '</span>',
            'after'       => '</div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
            'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'autohive' ) . ' </span>%',
            'separator'   => '<span class="screen-reader-text">, </span>',
        ));

        // If comments are open, or we have at least one comment, load up the comment template.
        if ( comments_open() || get_comments_number() ) :
            comments_template();
        endif;
        ?>
    </div>
</div>
<?php


get_footer();