<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package autohive
 */

get_header();

$sidebar = Autohive_Theme_Helper::render_sidebars('blog');
$row_class = $sidebar['row_class'];
$column = $sidebar['column'];
?>
<section class="blog-list-section ptb-120">
    <div class="container">
        <div class="row">
            <div class="col-xl-<?php echo esc_attr( $column ); ?>">
                <div class="blog-list-wrapper">
                    <?php
                    while (have_posts()) : the_post();
                        get_template_part('template-parts/contents/content', get_post_format());
                    endwhile;
                    ?>
                </div>
                <?php Autohive_Theme_Helper::autohive_post_pagination(); ?>
            </div>

            <?php echo (isset($sidebar['content']) && !empty($sidebar['content']) ) ? $sidebar['content'] : ''; ?>

        </div>
    </div>
</section>

<?php
get_footer();