<?php
/**
 * Autohive functions.
 *
 * @package autohive
 */

/**
 * Display Product Discount Percentage
 */
if ( !function_exists( 'autohive_show_sale_percentage_loop' ) ) {
	function autohive_show_sale_percentage_loop() {
		global $product;
		$max_percentage = 0;
		$percentage = 0;
		if ( ! $product->is_on_sale() ) return;
		if ( $product->is_type( 'simple' ) ) {
			$max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;
		}
		elseif ( $product->is_type( 'variable' ) ) {
			foreach ( $product->get_children() as $child_id ) {
				$variation = wc_get_product( $child_id );
				$price = $variation->get_regular_price();
				$sale = $variation->get_sale_price();
				if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
				if ( $percentage > $max_percentage ) {
					$max_percentage = $percentage;
				}
			}
		}
		if ( $max_percentage > 0 ) {
			echo '-' . round($max_percentage) . '%';
		}
	}
}

add_action( 'woocommerce_before_shop_loop_item_title', 'autohive_show_sale_percentage_loop', 25 );



/***
 * autohive_woocommerce_comments()
 */
function autohive_woocommerce_comments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);
	$user = wp_get_current_user();
	?>
	<li class="review_comment" id="comment-<?php comment_ID() ?>">
        <div class="d-flex align-items-center justify-content-between">
            <div class="top-left d-flex align-items-center mb-3">
	            <?php echo get_avatar($comment, 56, '', '', $args = array( 'class' => 'flex-shrink-0 rounded' )); ?>
                <div class="ms-3">
                    <h6 class="mb-1"><?php comment_author(); ?></h6>
                    <span><?php echo get_comment_time(get_option( 'date_format')); ?></span>
                </div>
            </div>
            <ul class="rating-field d-flex">
	            <?php woocommerce_review_display_rating() ?>
            </ul>
        </div>
		<?php comment_text() ?>
	</li>
	<?php
}


/**
 * Checkout form fields customizing
 */
add_filter( 'woocommerce_checkout_fields' , function ( $fields ) {

	$woocommerce_checkout_company_field = get_option('woocommerce_checkout_company_field');

	$woocommerce_checkout_phone_field = get_option('woocommerce_checkout_phone_field');
	$woocommerce_checkout_phone_required = ($woocommerce_checkout_phone_field == 'required') ? true : false;

	// Billing Fields
	$fields['billing']['billing_first_name'] = array(
		'label'         => esc_html__( 'First name', 'autohive' ),
		'placeholder'   => esc_html_x( 'First name', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-6' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true,
		'required'      => true
	);

	$fields['billing']['billing_last_name'] = array(
		'label'         => esc_html__( 'Last name', 'autohive' ),
		'placeholder'   => esc_html_x( 'Last name', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-6' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true,
		'required'      => true
	);

	$fields['billing']['billing_company'] = array(
		'label'         => esc_html__( 'Company name', 'autohive' ),
		'placeholder'   => esc_html_x( 'Company name', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12', $woocommerce_checkout_company_field ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true,
		'required'      => ( $woocommerce_checkout_company_field == 'required' ) ? true : false
	);

	$fields['billing']['billing_city'] = array(
		'label'         => esc_html__( 'Town / City', 'autohive' ),
		'placeholder'   => esc_html_x( 'Town / City', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['billing']['billing_address_1'] = array(
		'label'         => esc_html__('Street address', 'autohive'),
		'placeholder'   => esc_html_x( 'House number and street name', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['billing']['billing_address_2'] = array(
		'label'         => '',
		'placeholder'   => esc_html_x( 'Apartment, suite, unit, etc. (optional)', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['billing']['billing_state'] = array(
		'label'         => '',
		'placeholder'   => esc_html_x( 'Town / City *', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['billing']['billing_postcode'] = array(
		'label'         => esc_html__( 'Postcode / ZIP (optional)', 'autohive' ),
		'placeholder'   => esc_html_x( 'Postcode / ZIP (optional)', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['billing']['billing_phone'] = array(
		'label'         => esc_html__( 'Phone', 'autohive' ),
		'placeholder'   => esc_html_x( 'Phone', 'placeholder', 'autohive' ),
		'required'      => $woocommerce_checkout_phone_required,
		'class'         => array( 'col-lg-6', $woocommerce_checkout_phone_field ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$email_column = $woocommerce_checkout_phone_field=='hidden' ? '12' : '6';
	$fields['billing']['billing_email'] = array(
		'label'         => esc_html__( 'Email address', 'autohive' ),
		'placeholder'   => esc_html_x( 'Email address', 'placeholder', 'autohive' ),
		'required'      => true,
		'class'         => array( "col-lg-".$email_column ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);


	// Shipping Fields
	$fields['shipping']['shipping_first_name'] = array(
		'label'         => esc_html__( 'First name', 'autohive' ),
		'placeholder'   => esc_html_x( 'First name', 'placeholder', 'autohive' ),
		'required'      => false,
		'class'         => array( 'col-lg-6' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['shipping']['shipping_last_name'] = array(
		'label'         => esc_html__( 'Last name', 'autohive' ),
		'placeholder'   => esc_html_x( 'Last name', 'placeholder', 'autohive' ),
		'required'      => false,
		'class'         => array( 'col-lg-6' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['shipping']['shipping_company'] = array(
		'label'         => esc_html__( 'Company name (optional)', 'autohive' ),
		'placeholder'   => esc_html_x( 'Company name (optional)', 'placeholder', 'autohive' ),
		'required'      => false,
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['shipping']['shipping_city'] = array(
		'label'         => esc_html__( 'Town / City', 'autohive' ),
		'placeholder'   => esc_html_x( 'Town / City', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['shipping']['shipping_postcode'] = array(
		'label'         => esc_html__( 'Postcode / ZIP (optional)', 'autohive' ),
		'placeholder'   => esc_html_x( 'Postcode / ZIP (optional)', 'placeholder', 'autohive' ),
		'class'         => array( 'col-lg-12' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['shipping']['shipping_phone'] = array(
		'label'         => esc_html__( 'Phone', 'autohive' ),
		'placeholder'   => esc_html_x( 'Phone', 'placeholder', 'autohive' ),
		'required'      => $woocommerce_checkout_phone_required,
		'class'         => array( 'col-lg-6 '.$woocommerce_checkout_phone_field ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	$fields['shipping']['shipping_email'] = array(
		'label'         => esc_html__( 'Email address', 'autohive' ),
		'placeholder'   => esc_html_x( 'Email address', 'placeholder', 'autohive' ),
		'required'      => true,
		'class'         => array( 'col-lg-6' ),
		'input_class'   => array('w-100 border rounded'),
		'clear'         => true
	);

	return $fields;
});


/**
 * @return void
 * autohive_the_woo_product_ratting()
 * the function render only rating number count
 */
function autohive_the_woo_product_ratting() {
	global $product;
	$rating_count   = $product->get_rating_count();
	$average_rating = $product->get_average_rating();
	if ( $rating_count > 0 ) {
		?>
        <div class="ratting d-flex align-items-center">
			<?php echo wc_get_rating_html( $average_rating, $rating_count ); ?>
        </div>
		<?php
	}

}


/**
 * @return void
 * autohive_woo_the_ratting_count_with_text()
 * the function render woocommerce ratting count with user text info
 */
function autohive_woo_the_ratting_count_with_text() {
	global $product;
	$rating_count   = $product->get_rating_count();
	$average_rating = $product->get_average_rating();
	$review_count   = $product->get_review_count();

	$get_ratting = wc_get_rating_html( $average_rating, $rating_count );
    $get_review_count = sprintf(_n('%s review', '%s reviews', $review_count, 'autohive'), '<span class="fw-semibold">('.$review_count.'</span>').')';
    $total_ratting = $get_ratting.$get_review_count;

    if ( $rating_count > 0 ) {
	    ?>
        <div class="ratting d-flex align-items-center">
            <?php echo autohive_kses_post($total_ratting); ?>
        </div>
        <?php
    }

}



/*
 * Set post views count using post meta
 */
function autohive_set_post_views($postID) {
	$countKey = 'post_views_count';
	$count = get_post_meta($postID, $countKey, true);
	if ( $count == '' ) {
		$count = 0;
		delete_post_meta($postID, $countKey);
		add_post_meta($postID, $countKey, '0');
	} else {
		$count++;
		update_post_meta($postID, $countKey, $count);
	}
}

