<?php
/**
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Autohive
 * @version    2.6.1 for parent theme corid for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 */

require get_parent_theme_file_path( '/inc/tgm/class-tgm-plugin-activation.php' );

add_action( 'tgmpa_register', 'autohive_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 */
function autohive_register_required_plugins() {
	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(

		// Autohive Core Plugin
		array(
			'name'     => esc_attr__( 'Autohive Core', 'autohive' ),
			'slug'     => 'autohive-core',
			'source'   => ( 'https://autohive-wp.themetags.com/plugins/autohive-core.zip' ),
			'required' => true,
			'version'  => '1.0.0',
		),	

		// Codestar Framework
		array(
			'name'     => esc_attr__( 'Codestar Framework', 'autohive' ),
			'slug'     => 'codestar-framework',
			'source'   => ( 'https://autohive-wp.themetags.com/plugins/codestar-framework.zip' ),
			'required' => true,		
		),	

		// Elementor
		array(
			'name'     => esc_attr__( 'Elementor', 'autohive' ),
			'slug'     => 'elementor',
			'required' => true,
		),

		// Contact Form 7
		array(
			'name'     => esc_attr__( 'Contact Form 7', 'autohive' ),
			'slug'     => 'contact-form-7',
			'required' => true,
		),

		// One Click Demo Import
		array(
			'name'     => esc_attr__( 'One Click Demo Import', 'autohive' ),
			'slug'     => 'one-click-demo-import',
			'required' => false,
		),

		// WooCommerce
		array(
			'name'     => esc_attr__( 'WooCommerce', 'autohive' ),
			'slug'     => 'woocommerce',
			'required' => true,
		),

		// YITH WooCommerce Wishlist
		array(
			'name'     => esc_attr__( 'WooCommerce Wishlist', 'autohive' ),
			'slug'     => 'yith-woocommerce-wishlist',
			'required' => true,
		),

		// YITH WooCommerce Quick View
		array(
			'name'     => esc_attr__( 'WooCommerce Quick View', 'autohive' ),
			'slug'     => 'yith-woocommerce-quick-view',
			'required' => true,
		),

		//TT Compare Products
		array(
			'name'     => esc_attr__('TT Compare Products', 'autohive'),
			'slug'     => 'tt-woocommerce-compare-products',
			'source'   => ('https://autohive-wp.themetags.com/plugins/tt-woocommerce-compare-products.zip'),
			'required' => true,
		),	

	);

	/*
	 * Config for TGMPA
	 */
	$config = array(
		'id'           => 'autohive',
		'default_path' => '',
		'menu'         => 'autohive-install-plugins',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '',
		'is_automatic' => false,
		'message'      => '',
	);

	tgmpa( $plugins, $config );
}