<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package autohive
 */

if ( ! function_exists( 'autohive_get_title_tag' ) ) {
	/**
	 * Returns array of title tags
	 *
	 * @param bool $first_empty
	 * @param array $additional_elements
	 *
	 * @return array
	 */
	function autohive_get_title_tag( $first_empty = false, $additional_elements = array() ) {
		$title_tag = array();

		if ( $first_empty ) {
			$title_tag[''] = esc_html__( 'Default', 'autohive' );
		}

		$title_tag['h1'] = 'h1';
		$title_tag['h2'] = 'h2';
		$title_tag['h3'] = 'h3';
		$title_tag['h4'] = 'h4';
		$title_tag['h5'] = 'h5';
		$title_tag['h6'] = 'h6';

		if ( ! empty( $additional_elements ) ) {
			$title_tag = array_merge( $title_tag, $additional_elements );
		}

		return $title_tag;
	}
}

// Autohive Kses Post ================
if ( ! function_exists( 'autohive_kses_post' ) ) {
    function autohive_kses_post( $content ) {
        $allowed_tag = array(
            'strong' => [],
            'p' => [],
            'span' => [
                'class' => [],
                'style' => []
            ],
            'br' => [],
            'a' => [
                'href' => [],
                'class' => [],
            ],
            'img' => [
                'src' => [],
                'srcset' => [],
                'width' => [],
                'height' => [],
                'class' => [],
                'alt' => [],
            ],
            'div' => [
                'class' => [],
                'style' => []
            ],
            'h1' => [
                'class' => [],
                'style' => []
            ],
            'h2' => [
                'class' => [],
                'style' => []
            ],
            'h3' => [
                'class' => [],
                'style' => []
            ],
            'h4' => [
                'class' => [],
                'style' => []
            ],
            'h5' => [
                'class' => [],
                'style' => []
            ],
            'h6' => [
                'class' => [],
                'style' => []
            ],
            'mark' => [
                'class' => [],
                'style' => []
            ],
        );
        return wp_kses( $content, $allowed_tag );
    }
}

// A Custom function for get an option
if ( ! function_exists( 'autohive_opt' ) ) {
	function autohive_opt( $option = '', $default = null ) {

        $options = get_option( 'autohive_cs_opt' );

		return ( isset( $options[ $option ] ) ) ? $options[ $option ] : $default;
	}
}

/**
 * Elementor post type support
 */
function autohive_add_cpt_support()
{

    //if exists, assign to $cpt_support var
    $cpt_support = get_option('elementor_cpt_support');

    //check if option DOESN'T exist in db
    if (!$cpt_support) {
        $cpt_support = ['page', 'autohive_rent', 'autohive_listing', 'autohive_footer', 'listing_dealer', 'mega_menu', 'service' ]; //create array of our default supported post types
        update_option('elementor_cpt_support', $cpt_support); //write it to the database
    }

    //if it DOES exist, but page is NOT defined
    elseif (!in_array('page', $cpt_support)) {
        $cpt_support[] = 'page'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
    //if it DOES exist, but autohive_rent is NOT defined
    elseif (!in_array('autohive_rent', $cpt_support)) {
        $cpt_support[] = 'autohive_rent'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
    //if it DOES exist, but autohive_listing is NOT defined
    elseif (!in_array('autohive_listing', $cpt_support)) {
        $cpt_support[] = 'autohive_listing'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
    //if it DOES exist, but autohive_footer is NOT defined
    elseif (!in_array('autohive_footer', $cpt_support)) {
        $cpt_support[] = 'autohive_footer'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
    //if it DOES exist, but listing_dealer is NOT defined
    elseif (!in_array('listing_dealer', $cpt_support)) {
        $cpt_support[] = 'listing_dealer'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
    //if it DOES exist, but mega_menu is NOT defined
    elseif (!in_array('mega_menu', $cpt_support)) {
        $cpt_support[] = 'mega_menu'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
    //if it DOES exist, but service is NOT defined
    elseif (!in_array('service', $cpt_support)) {
        $cpt_support[] = 'service'; //append to array
        update_option('elementor_cpt_support', $cpt_support); //update database
    }
}
add_action('after_switch_theme', 'autohive_add_cpt_support');