<?php

if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.


// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {


	/**
	 * Autohive - Listing Brands Taxonomy
	 *
	 * Set a unique slug-like ID
	 */
	$prefix_listing = 'autohive_taxonomy_options';

	// Create taxonomy options
	CSF::createTaxonomyOptions( $prefix_listing, array(
		'taxonomy' => 'autohive_listing_brand',
	) );

	// Create a section
	CSF::createSection( $prefix_listing, array(
		'fields' => array(
			array(
				'id'        => 'autohive_listing_brand_icon',
				'type'      => 'media',
				'title'     => esc_html__( 'Upload Brand Logo', 'autohive' ),
			),
			array(
				'id'        => 'listing_brand_icon_hover',
				'type'      => 'media',
				'title'     => esc_html__( 'Upload Brand Hover Logo', 'autohive' ),
			),
		)
	) );



	/**
	 * Autohive - FAQs Category Taxonomy
	 *
	 * Set a unique slug-like ID
	 */
	$prefix_faq = 'faq_cat';

	// Create taxonomy options -
	CSF::createTaxonomyOptions( $prefix_faq, array(
		'taxonomy' => 'faq_cat',
		'data_type' => 'serialize'
	) );

	// Create a section
	CSF::createSection( $prefix_faq, array(
		'fields' => array(

			array(
				'id'        => 'faq_icon',
				'type'      => 'icon',
				'title'     => esc_html__( 'Select Icon', 'autohive' ),
			),
		)
	) );


}


