<?php

// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {

	//
	// Set a unique slug-like ID
	$prefix = 'tt_page_options';

	//
	// Create a metabox
	CSF::createMetabox( $prefix, array(
		'title'     => esc_html__( 'Page Option', 'autohive' ),
		'context'   => 'normal',
		'post_type' => array( 'page', 'autohive_rent' ),
		'theme'     => 'dark',

	) );

	// Header Menu
	CSF::createSection( $prefix, array(
		'title'  => esc_html__( 'Header', 'autohive' ),
		'icon'   => 'fa fa-home',
		'fields' => array(
			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Header Style', 'autohive' ),
			),

			array(
				'id'      => 'header_layout',
				'type'    => 'select',
				'title'   => esc_html__( 'Header Layout', 'autohive' ),
				'options' => array(
					'1'  		=> esc_html__( 'Default', 'autohive' ),
					'2' => esc_html__( 'Layout 02', 'autohive' ),
				),
				'default' => 'default',
			),

			array(
				'id'        => 'header_bg_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Header Background Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change header background color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'background-color'  => '.at_header_nav',
				)
			),
			
			array(
				'id'        => 'sticky_header_bg_color',
				'type'      => 'color',
				'title'     => esc_html__( 'Sticky Header Background Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change sticky header background color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'background'      => '.sticky-on .at_header_nav',
				)
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Logo', 'autohive' ),
			),
			array(
				'id'       => 'page_logo',
				'type'     => 'switcher',
				'title'    => __( 'Page Logo', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => true
			),
			array(
				'id'         => 'meta_main_logo',
				'type'       => 'media',
				'title'      => esc_html__( 'Logo Upload', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'desc'       => esc_html__( 'Upload logo for Header', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'id'         => 'retina_logo',
				'type'       => 'media',
				'title'      => esc_html__( 'Retina Logo Upload @2x', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'desc'       => esc_html__( 'Upload your Retina Logo. This should be your Logo in double size (If your logo is 100 x 20px, it should be 200 x 40px)', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'id'         => 'meta_sticky_logo',
				'type'       => 'media',
				'title'      => esc_html__( 'Sticky Logo', 'autohive' ),
				'desc'       => esc_html__( 'Upload logo for Header Sticky and Inner Page.', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'id'         => 'retina_logo_sticky',
				'type'       => 'media',
				'title'      => esc_html__( 'Sticky Retina Logo @2x', 'autohive' ),
				'desc'       => esc_html__( 'Upload Retina logo for Header Sticky.', 'autohive' ),
				'add_title'  => esc_html__( 'Upload', 'autohive' ),
				'dependency'       => array( 'page_logo', '==', true ),
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Header Menu Style', 'autohive' ),
			),

			array(
				'id'      => 'menu_alignment',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Menu Alignment', 'autohive' ),
				'options' => array(
					'me-auto'	=> esc_html__( 'Left', 'autohive' ),
					'm-auto'	=> esc_html__( 'Center', 'autohive' ),
					'ms-auto'	=> esc_html__( 'Right', 'autohive' ),
				),
				'default' => 'ms-auto'
			),

			array(
				'id'     => 'menu_color',
				'type'   => 'color',
				'title'  => esc_html__( 'Menu Text Color', 'autohive' ),
				'desc'   => esc_html__( 'You can change menu text color.', 'autohive' ),
				'output' => array(
					'color' => '.at_nav_menu ul li a',
				),
			),

			array(
				'id'        => 'menu_color_hover',
				'type'      => 'color',
				'title'     => esc_html__( 'Menu Text Hover Color', 'autohive' ),
				'desc'      => esc_html__( 'You can change menu text hover color.', 'autohive' ),
				'add_title' => esc_html__( 'Upload', 'autohive' ),
				'output'    => array(
					'color'      => '.at_nav_menu ul li a:hover',
				)
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Header Sticky Menu Style', 'autohive' ),
			),

			array(
				'id'               => 'sticky_menu_color',
				'type'             => 'color',
				'title'            => esc_html__( 'Menu Text Color', 'autohive' ),
				'desc'             => esc_html__( 'You can change menu text color.', 'autohive' ),
				'output_important' => true,
				'output' => [
					'color' => '.sticky-on .at_nav_menu ul li a',
				]
			),

			array(
				'id'               => 'sticky_menu_color_hover',
				'type'             => 'color',
				'output_important' => true,
				'title'            => esc_html__( 'Menu Text Hover Color', 'autohive' ),
				'desc'             => esc_html__( 'You can change menu text hover color.', 'autohive' ),
				'add_title'        => esc_html__( 'Upload', 'autohive' ),
				'output'           => array(
					'color' => '.sticky-on .at_nav_menu ul li a:hover',
				)
			),

			array(
				'type'    => 'subheading',
				'content' => esc_html__( 'Call To Action', 'autohive' ),
			),

			array(
				'id'       => 'is_cta_enabled',
				'type'     => 'switcher',
				'title'    => __( 'Call To Action', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => false
			),
		)
		
	) );

	// Page Header
	CSF::createSection( $prefix, array(
		'title'  => 'Page Header',
		'icon'   => 'fa fa-picture-o',
		'fields' => array(

			array(
				'id'      => 'meta_page_header',
				'type'    => 'button_set',
				'title'   => esc_html__( 'Page Header Option', 'autohive' ),
				'options' => array(
					'default'  => esc_html__( 'Default', 'autohive' ),
					'enabled'  => esc_html__( 'Enabled', 'autohive' ),
					'disabled' => esc_html__( 'Disabled', 'autohive' ),
				),
				'default' => 'default'
			),

			array(
				'id'               => 'header_image',
				'type'             => 'background',
				'title'            => esc_html__( 'Header Image', 'autohive' ),
				'desc'             => esc_html__( 'Default: Featured image, if fail will get image from global settings.', 'autohive' ),
				'dependency'       => array( 'meta_page_header', '==', 'enabled' ),
				'output'           => '.page-header',
				'output_important' => true,
			),

			array(
				'id'         => 'custom_title',
				'type'       => 'text',
				'title'      => esc_html__( 'Custom Title', 'autohive' ),
				'desc'       => esc_html__( 'Set custom title for the page header. Default: The post title.', 'autohive' ),
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
			),

			array(
				'id'         => 'meta_page_header_description',
				'type'       => 'textarea',
				'title'      => esc_html__( 'Page Description', 'autohive' ),
				'desc'       => esc_html__( 'Set custom title for the page header. Default: The post title.', 'autohive' ),
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
			),

			array(
				'id'         => 'custom_title_typography',
				'type'       => 'typography',
				'title'      => esc_html__( 'Title Typography', 'autohive' ),
				'output'     => '.page-banner .page-title',
				'dependency' => array( 'page_header', '==', 'enabled' ),
			),
			array(
				'id'         => 'custom_title_color',
				'type'       => 'color',
				'title'      => esc_html__( 'Title Color', 'autohive' ),
				'output'     => '.page-banner .page-title',
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
			),

			array(
				'id'         => 'breadcrumbs',
				'type'       => 'switcher',
				'title'      => esc_html__( 'Header Breadcrumbs', 'autohive' ),
				'desc'       => esc_html__( 'Display breadcrumbs on the page header', 'autohive' ),
				'dependency' => array( 'meta_page_header', '==', 'enabled' ),
				'default'    => true,
			),

		),
	) );

	// Footer Menu
	CSF::createSection( $prefix, array(
		'title'  => esc_html__( 'Footer', 'autohive' ),
		'icon'   => 'fa fa-home',
		'fields' => array(

			array(
				'id'       => 'meta_footer_type',
				'type'     => 'switcher',
				'title'    => __( 'Footer Style', 'autohive' ),
				'text_on'  => __( 'Yes', 'autohive' ),
				'text_off' => __( 'No', 'autohive' ),
				'default'  => false
			),

			array(
				'id'          => 'meta_footer_style',
				'type'        => 'select',
				'title'       => __('Select Footer Style', 'autohive' ),
				'options'     => Autohive_Theme_Helper::get_post_list( 'autohive_footer' ),
				'dependency' => array( 'meta_footer_type', '==', 'true' ),
			),

			array(
				'id'         => 'meta_footer_color',
				'type'       => 'button_set',
				'title'      => __( 'Switch Footer Dark or Light', 'autohive' ),
				'options'    => array(
					'footer_dark'  => __( 'Dark', 'autohive' ),
					'footer_light' => __( 'Light', 'autohive' ),
				),
				'default'    => 'footer_dark',
				'dependency' => array( 'meta_footer_type', '==', 'true' ),
			),

			array(
				'id'          => 'meta_footer_padding_top',
				'type'        => 'spacing',
				'title'       => __( 'Padding Top', 'autohive' ),
				'output'      => '.site-footer .footer-wrapper',
				'output_mode' => 'padding', //
				'left'        => false,
				'right'       => false,
				'dependency'  => array( 'meta_footer_type', '==', 'true' ),
			),
		)
	) );
}