<?php
// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {


	// Set a unique slug-like ID
	$prefix = 'autohive_listing_meta';


	// Create a metabox - Listing Manager
	CSF::createMetabox( $prefix, array(
		'title'     => 'Listing Manager',
		'post_type' => 'autohive_listing',
		'data_type' => 'unserialize'
	) );

	// Create a section - Price
	CSF::createSection( $prefix, array(
		'title'  => esc_html__('General Info','autohive'),
		'icon'   => '',
		'fields' => array(

			array(
				'id'      => 'featured',
				'type'    => 'checkbox',
				'title'   => esc_html__( 'Featured', 'autohive' ),
			),

			array(
				'id'      => 'rent_or_sale',
				'type'    => 'text',
				'title'   => esc_html__('Rent/Sale', 'autohive'),
				'default' => 'For Sale'
			),

			array(
				'id'          => 'listing_thumb_gallery',
				'type'        => 'gallery',
				'title'       => 'Gallery',
				'add_title'   => 'Add Images',
				'edit_title'  => 'Edit Images',
				'clear_title' => 'Remove Images',
			),

			array(
				'id'          => 'select_dealer',
				'type'        => 'select',
				'title'       => __('Select Dealer', 'autohive'),
				'options'     => Autohive_Theme_Helper::get_post_list('listing_dealer')
			),

			array(
				'id'        => 'car_features_tab',
				'type'      => 'group',
				'title'     => __('Car Features', 'autohive'),
				'fields'    => array(
					array(
						'id'    => 'features_tab_title',
						'type'  => 'text',
						'title' => __('Tab Title', 'autohive')
					),
					array(
						'id'        => 'car_features',
						'type'      => 'group',
						'title'     => 'Group',
						'fields'    => array(
							array(
							'id'    => 'feature_item',
							'type'  => 'text',
							'title' => __('Feature Text', 'autohive' )
							),
						),
					)
					
				),
				
			),

		)
	) );


	// Create a section - Features
	CSF::createSection( $prefix, array(
		'title'  => esc_html__('Features','autohive'),
		'icon'   => '',
		'fields' => array(

			array(
				'id'      => 'regular_price',
				'type'    => 'text',
				'title'   => esc_html__('Price', 'autohive'),
				'default' => '$174,900'
			),
			
			array(
				'id'      => 'car_model',
				'type'    => 'text',
				'title'   => esc_html__( 'Car Model', 'autohive' ),
				'default' => 'Ferrari F12 TRS'
			),
			
		
			array(
				'id'          => 'car_body_type',
				'type'        => 'select',
				'title'       => __( 'Select Body Type', 'autohive'),
				'after' 	  => __( 'If body type field is empty then you have to add body type from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::listing_body_type(),
				
			),
			
			array(
				'id'      => 'mileage',
				'type'    => 'text',
				'title'   => esc_html__( 'Mileage', 'autohive' ),
				'default' => '70,000 (Mi)'
			),

			array(
				'id'      => 'car_transmissions',
				'type'    => 'select',
				'title'   => esc_html__('Car Transmissions', 'autohive'),
				'options' => array(
					'manual'		=> __('Manual', 'autohive'),
					'automatic'		=> __('Automatic', 'autohive'),
					'continuously-variable' => __('Continuously Variable', 'autohive'),
					'semi-automatic' => __('Semi-Automatic', 'autohive'),
					'dual-clutch'	=> __('Dual Clutch', 'autohive')
				),
				'default' => 'manual'
			),

			array(
				'id'      => 'car_engine_size',
				'type'    => 'text',
				'title'   => esc_html__( 'Car Engine Size', 'autohive' ),
				'default' => '120cc'
			),

			array(
				'id'      => 'fuel_type',
				'type'    => 'text',
				'title'   => esc_html__( 'Fuel Type', 'autohive' ),
				'default' => 'Petrol'
			),
			
			array(
				'id'      => 'condition',
				'type'    => 'text',
				'title'   => esc_html__( 'Condition', 'autohive' ),
				'default' => 'New'
			),

			array(
				'id'      => 'build_year',
				'type'    => 'number',
				'title'   => esc_html__('Build Year', 'autohive'),
				'default' => '2017'
			),
			
			array(
				'id'      => 'drivetrian',
				'type'    => 'text',
				'title'   => esc_html__('Drivetrian', 'autohive'),
				'default' => 'Front Wheel'
			),
			
			array(
				'id'      => 'car_color',
				'type'    => 'text',
				'title'   => esc_html__('Car Color', 'autohive'),
				'default' => __( 'Black', 'autohive')
			),
			array(
				'id'      => 'cylinders',
				'type'    => 'text',
				'title'   => esc_html__('Engine Cylinders', 'autohive'),
				'default' => '6'
			),
			array(
				'id'      => 'car_vin',
				'type'    => 'text',
				'title'   => esc_html__('VIN', 'autohive'),
				'default' => __('1C4TJPBA1CD', 'autohive')
			),
			array(
				'id'      => 'car_doors',
				'type'    => 'text',
				'title'   => esc_html__('Doors', 'autohive'),
				'default' => __('2 Doors', 'autohive')
			),
			array(
				'id'      => 'car_location',
				'type'    => 'text',
				'title'   => esc_html__('Location', 'autohive'),
				'default' => __('New York City, USA', 'autohive')
			),

		)
	) );



}
