<?php
// Control core classes for avoid errors
if (class_exists('CSF')) {


	// Set a unique slug-like ID
	$prefix = 'listing_rent_meta';


	// Create a metabox - Dealer Listing
	CSF::createMetabox($prefix, array(
		'title'     => __('Listing Rent Info', 'autohive'),
		'post_type' => 'autohive_rent',
		'data_type' => 'unserialize'
	));


	// Create a section - General Info
	CSF::createSection($prefix, array(
		'title'  => esc_html__('General Info', 'autohive'),
		'icon'   => '',
		'fields' => array(

			array(
				'id'      => 'featured',
				'type'    => 'checkbox',
				'title'   => esc_html__('Featured Agent', 'autohive'),
			),
			array(
				'id'      => 'daily_rent',
				'type'    => 'text',
				'title'   => esc_html__('Rent Daily', 'autohive'),
				'default' => '$150'
			),
			array(
				'id'      => 'monthly_rent',
				'type'    => 'text',
				'title'   => esc_html__('Rent Monthly', 'autohive'),
				'default' => '$3900'
			),
			array(
				'id'          => 'select_dealer',
				'type'        => 'select',
				'title'       => __('Select Dealer', 'autohive'),
				'options'     => Autohive_Theme_Helper::get_post_list('listing_dealer')
			),
		)
	));


	// Create a section - Dealer Information
	CSF::createSection($prefix, array(
		'title'  => esc_html__(' Information', 'autohive'),
		'icon'   => '',
		'fields' => array(
			array(
				'id'        => 'vehicle_type',
				'type'      => 'button_set',
				'title'     => 'Vehicle Type',
				'options'   => array(
					'car'	=> 'New Car',
					'motor' => 'Motor Bike',
				),
				'default'    => 'car'
			),
			
			array(
				'id'          => 'pickup_location',
				'type'        => 'select',
				'title'       => __('Car Pickup Location', 'autohive'),
				'after' 	  => __('If Pickup Location field is empty then you have to add Car Branch Location from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::car_pickup_location(),
				'chosen'      => true,
				'multiple'    => true,
			),

			array(
				'id'       => 'available_days',
				'type'     => 'datetime',
				'title'    => __('Available From', 'autohive'),
				'settings' => [
					'dateFormat' => 'Y-m-d',
				]
			),

			array(
				'id'          => 'return_location',
				'type'        => 'select',
				'title'       => __('Car Return Location', 'autohive'),
				'after' 	  => __('If Pickup Location field is empty then you have to add Car Branch Location from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::car_pickup_location(),
				'chosen'      => true,
				'multiple'    => true,
			),

			array(
				'id'          => 'car_bodytype',
				'type'        => 'select',
				'title'       => __('Select Body Type', 'autohive'),
				'after' 	  => __('If body type field is empty then you have to add body type from Theme Options > Listing', 'autohive'),
				'placeholder' => 'Select an option',
				'options'     => Autohive_Theme_Helper::listing_body_type(),
			),

			array(
				'id'      => 'mileage',
				'type'    => 'text',
				'title'   => esc_html__('Mileage', 'autohive'),
				'default' => '70,000 (Mi)'
			),

			array(
				'id'      => 'car_transmissions',
				'type'    => 'select',
				'title'   => esc_html__('Car Transmissions', 'autohive'),
				'options' => array(
					'manual'		=> __('Manual', 'autohive'),
					'automatic'		=> __('Automatic', 'autohive'),
					'continuously-variable' => __('Continuously Variable', 'autohive'),
					'semi-automatic'=> __('Semi-Automatic', 'autohive'),
					'dual-clutch'	=> __('Dual Clutch', 'autohive')
				),
				'default' => 'manual'
			),

			array(
				'id'      => 'car_engine_size',
				'type'    => 'text',
				'title'   => esc_html__('Car Engine Size', 'autohive'),
				'default' => '120cc'
			),

			array(
				'id'      => 'fuel_type',
				'type'    => 'text',
				'title'   => esc_html__('Fuel Type', 'autohive'),
				'default' => 'Petrol'
			),


			array(
				'id'      => 'build_year',
				'type'    => 'number',
				'title'   => esc_html__('Build Year', 'autohive'),
				'default' => '2017'
			),

			array(
				'id'      => 'drivetrian',
				'type'    => 'text',
				'title'   => esc_html__('Drivetrian', 'autohive'),
				'default' => 'Front Wheel'
			),

			array(
				'id'      => 'car_color',
				'type'    => 'text',
				'title'   => esc_html__('Car Color', 'autohive'),
				'default' => __('Black', 'autohive')
			),
			array(
				'id'      => 'cylinders',
				'type'    => 'text',
				'title'   => esc_html__('Engine Cylinders', 'autohive'),
				'default' => '6'
			),
			array(
				'id'      => 'car_vin',
				'type'    => 'text',
				'title'   => esc_html__('VIN', 'autohive'),
				'default' => __('1C4TJPBA1CD', 'autohive')
			),
			array(
				'id'      => 'car_doors',
				'type'    => 'text',
				'title'   => esc_html__('Doors', 'autohive'),
				'default' => __('2 Doors', 'autohive')
			),
			array(
				'id'      => 'passengers',
				'type'    => 'text',
				'title'   => esc_html__('Passengers', 'autohive'),
				'default' => __('06', 'autohive')
			),
			array(
				'id'      => 'suitcase',
				'type'    => 'text',
				'title'   => esc_html__('Suitcase', 'autohive'),
				'default' => __('1 Large, 2 Small', 'autohive')
			),
			array(
				'id'          => 'car_loacation',
				'type'        => 'text',
				'title'       => __('Car Location', 'autohive'),
				'default' 	  => __('Wast San Park St, New York, NY 98', 'autohive')				
			),


		)
	));
}
