<?php
// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {


	// Set a unique slug-like ID
	$prefix = 'listing_motors';


	// Create a metabox - Dealer Listing
	CSF::createMetabox( $prefix, array(
		'title'     => __('Motors Dealer Info', 'autohive'),
		'post_type' => 'listing_motor',
		'data_type' => 'unserialize'
	) );



	// Create a section - Dealer Information
	CSF::createSection( $prefix, array(
		'title'  => esc_html__('Motor Information','autohive'),
		'icon'   => '',
		'fields' => array(

			array(
				'id'      => 'stock_status',
				'type'    => 'text',
				'title'   => esc_html__('Product Status', 'autohive'),
				'default' => ''
			),
			
			array(
				'id'      => 'regular_price',
				'type'    => 'text',
				'title'   => esc_html__('Price', 'autohive'),
				'default' => '$174,900'
			),

			array(
				'id'      => 'car_model',
				'type'    => 'text',
				'title'   => esc_html__('Car Model', 'autohive'),
				'default' => 'Ferrari F12 TRS'
			),

			array(
				'id'      => 'horsepower',
				'type'    => 'text',
				'title'   => esc_html__('Car Model', 'autohive'),
				'default' => '130'
			),
			
			array(
				'id'      => 'displacement',
				'type'    => 'text',
				'title'   => esc_html__('Displacement', 'autohive'),
				'default' => '200 cc'
			),

			array(
				'id'      => 'mileage',
				'type'    => 'text',
				'title'   => esc_html__('Mileage', 'autohive'),
				'default' => '70,000 (Mi)'
			),

			array(
				'id'      => 'car_transmissions',
				'type'    => 'select',
				'title'   => esc_html__('Car Transmissions', 'autohive'),
				'options' => array(
					'manual'		=> __('Manual', 'autohive'),
					'automatic'		=> __('Automatic', 'autohive'),
					'continuously-variable' => __('Continuously Variable', 'autohive'),
					'semi-automatic' => __('Semi-Automatic', 'autohive'),
					'dual-clutch'	=> __('Dual Clutch', 'autohive')
				),
				'default' => 'manual'
			),

			array(
				'id'      => 'car_engine_size',
				'type'    => 'text',
				'title'   => esc_html__('Car Engine Size', 'autohive'),
				'default' => '120cc'
			),

			array(
				'id'      => 'fuel_type',
				'type'    => 'text',
				'title'   => esc_html__('Fuel Type', 'autohive'),
				'default' => 'Petrol'
			),

			array(
				'id'      => 'condition',
				'type'    => 'text',
				'title'   => esc_html__('Condition', 'autohive'),
				'default' => 'New'
			),
			
			array(
				'id'      => 'break_type',
				'type'    => 'text',
				'title'   => esc_html__('Break Type', 'autohive'),
				'default' => 'Double Disc'
			),

			array(
				'id'      => 'build_year',
				'type'    => 'number',
				'title'   => esc_html__('Build Year', 'autohive'),
				'default' => '2017'
			),

			array(
				'id'      => 'car_color',
				'type'    => 'text',
				'title'   => esc_html__('Car Color', 'autohive'),
				'default' => __('Black', 'autohive')
			),

			

		)
	) );


}
