<?php
// Control core classes for avoid errors
if ( class_exists( 'CSF' ) ) {


	// Set a unique slug-like ID
	$prefix = 'listing_dealer_meta';


	// Create a metabox - Dealer Listing
	CSF::createMetabox( $prefix, array(
		'title'     => __('Listing Dealer Info', 'autohive'),
		'post_type' => 'listing_dealer',
		'data_type' => 'unserialize'
	) );


	// Create a section - General Info
	CSF::createSection( $prefix, array(
		'title'  => esc_html__('General Info','autohive'),
		'icon'   => '',
		'fields' => array(

			array(
				'id'      => 'featured',
				'type'    => 'checkbox',
				'title'   => esc_html__( 'Featured Agent', 'autohive' ),
			),

		)
	) );


	// Create a section - Dealer Information
	CSF::createSection( $prefix, array(
		'title'  => esc_html__('Dealer Information','autohive'),
		'icon'   => '',
		'fields' => array(

			array(
				'id'      => 'dealer_avatar',
				'type'    => 'media',
				'title'   => esc_html__( 'Dealer Avatar', 'autohive' ),
			),

			array(
				'id'      => 'dealer_locations',
				'type'    => 'text',
				'title'   => esc_html__( 'Locations', 'autohive' ),
				'default' => 'New York City, USA'
			),

			array(
				'id'      => 'dealer_contact_num',
				'type'    => 'text',
				'title'   => esc_html__( 'Contact Number', 'autohive' ),
				'default' => '+9087784565154'
			),

			array(
				'id'      => 'dealer_email',
				'type'    => 'text',
				'title'   => esc_html__( 'Email', 'autohive' ),
				'default' => 'autohive@gmail.com'
			),
			array(
				'id'       => 'opening_closed',
				'type'     => 'datetime',
				'title'    => 'Opening and Closing Time',
				'from_to'  => true,
				'time_24hr'  => false,
				'settings' => array(
					'noCalendar' => true,
					'enableTime' => true,
				),
			),

			array(
				'id'     => 'dealer_social_icons',
				'type'   => 'repeater',
				'title'  => __('Social Icon', 'autohive'),
				'button_title' => __('Add Icon', 'autohive'),
				'fields' => array(

					array(
						'id'      => 'social_icon',
						'type'    => 'icon',
						'title'   => esc_html__( 'Icon', 'autohive' ),
						'default' => 'facebook-f'
					),

					array(
						'id'    => 'social_icon_url',
						'type'  => 'text',
						'title'   => esc_html__( 'Icon URL', 'autohive' ),
						'default' => '#'
					),

				),
			),

		)
	) );


}
