<?php
// Woocommerce
if( class_exists( 'WooCommerce' ) ){
	CSF::createSection( $prefix, array(
		'id' => 'woocommerce_section',
		'title'  => __( 'Woocommerce', 'autohive' ),
		'icon'  => 'fa fa-shopping-cart',
		'fields' => array(

			// A text field
			array(
				'id'      => 'shop_sidebar_layout',
				'type'    => 'image_select',
				'title'   => esc_html__( 'Layout', 'autohive' ),
				'radio'   => true,
				'options' => array(
					'left'       => AUTOHIVE_DIR_IMG . '/layout/left-sidebar.png',
					'no-sidebar' => AUTOHIVE_DIR_IMG . '/layout/no-sidebar.png',
					'right'      => AUTOHIVE_DIR_IMG . '/layout/right-sidebar.png',
				),
				'default' => 'right',
			),

			array(
				'id'       => 'product_style',
				'type'     => 'button_set',
				'title'    => __('Product Style', 'autohive'),
				'multiple' => false,
				'options'  => array(
					'style_one'   => __('One', 'autohive'),
					'style_two'   => __('Two', 'autohive'),
				),
				'default'  => 'style_one'
			),

			array(
				'id'       => 'shop_column',
				'type'     => 'button_set',
				'title'    => 'Column',
				'multiple' => false,
				'options'  => array(
					'6'   => 'Two',
					'4'   => 'Three',
					'3' => 'Four',
				),
				'default'  => '4'
			),

			array(
				'id'       => 'shop_sidebar_def_width',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Blog Archive Sidebar Width', 'autohive' ),
				'options'  => array(
					'9' => '25%',
					'8' => '33%',
				),
				'default'  => '8',
				'required' => array( 'shop_sidebar_layout', '!=', 'none' ),
			),

			array(
				'id'       => 'shop_sidebar_gap',
				'type'     => 'select',
				'title'    => esc_html__( 'Blog Archive Sidebar Side Gap', 'autohive' ),
				'options'  => array(
					'def' => 'Default',
					'0'   => '0',
					'15'  => '15',
					'20'  => '20',
					'25'  => '25',
					'30'  => '30',
					'35'  => '35',
					'40'  => '40',
					'45'  => '45',
					'50'  => '50',
					'75'  => '75',
					'85'  => '85',
					'100' => '100',
				),
				'default'  => '30',
				'required' => array( 'shop_sidebar_layout', '!=', 'none' ),
			),

			array(
				'id'      => 'shop_products_per_page',
				'type'    => 'number',
				'title'   => __('product Per Page', 'autohive'),
				'default' => 12,
			),

			array(
				'id'      => 'shop_related_per_page',
				'type'    => 'number',
				'title'   => __('Related product Per Page', 'autohive'),
				'default' => 3,
			),

			array(
				'id'      => 'single_related_post',
				'type'    => 'switcher',
				'title'   => esc_html__( 'Related Post Show/Hide', 'autohive' ),
				'default' => false
			),

			array(
				'type'       => 'text',
				'title'      => esc_html__( 'Related Post Tittle', 'autohive' ),
				'id'         => 'related_title',
				'default'    => __( 'Related Post', 'autohive' ),
				'dependency' => array( 'single_related_post', '==', true ),
			),

			array(
				'type'       => 'text',
				'title'      => esc_html__( 'Related Post Tittle', 'autohive' ),
				'id'         => 'related_description',
				'default'    => __( 'Related Post', 'autohive' ),
				'dependency' => array( 'single_related_post', '==', true ),
			),
		)
	) );
}