<?php
// Car Body Type
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Listing', 'autohive' ),
	'icon'   => 'fas fa-plus',
	'fields' => array(

		array(
			'id'        => 'car_body_type_group',
			'type'      => 'group',
			'title'     => __('Car Body Types', 'autohive' ),
			'fields'    => array(
				array(
					'id'    => 'body_type_name',
					'type'  => 'text',
					'title' => __('Body Type Name', 'autohive' )
			  	),
			  	array(
					'id'    => 'body_type_img',
					'type'  => 'media',
					'title' => __('Body Type Image', 'autohive' )
			  	),

			),
			'default'   => array(
				array(
					'body_type_name' => 'Crossover',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/crossover-red.svg'
					]
				),
				array(
					'body_type_name' => 'Suv',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/suv-red.svg'
					]
				),
				array(
					'body_type_name' => 'Sedan',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/sedan-red.svg'
					]
				),
				array(
					'body_type_name' => 'Wagon',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/wagon-red.svg'
					]
				),
				array(
					'body_type_name' => 'Coup',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/coup-red.svg'
					]
				),
				array(
					'body_type_name' => 'Convertible',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/convertible-red.svg'
					]
				),
				array(
					'body_type_name' => 'Compact',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/compact-red.svg'
					]
				),
				array(
					'body_type_name' => 'Sport Coupe',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/sport-coupe-red.svg'
					]
				),
				array(
					'body_type_name' => 'Pickup',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/pickup-red.svg'
					]
				),
				array(
					'body_type_name' => 'Family MPV',
					'body_type_img' => [
						'url'	=> trailingslashit(get_template_directory_uri()) . 'assets/images/body-type/mpv-red.svg'
					]
				)
			)
		),

		// Car pickup location
		array(
			'id'        => 'car_pickup_locations',
			'type'      => 'repeater',
			'title'     => __('Car Branch Locations', 'autohive'),
			'button_title' => __( 'Add New Location', 'autohive'),
			'fields'    => array(
				array(
					'id'    => 'location',
					'type'  => 'text',
					'title' => __('Location Name', 'autohive')
				)
			),
			'default'   => array(
				array(
					'location' => 'Dhaka',
				),
				array(
					'location' => 'Sylhet',
				),
				array(
					'location' => 'Chittagong',
				),
				array(
					'location' => 'Rajshahi',
				),
				array(
					'location' => 'Barishal',
				),
				array(
					'location' => 'Noakhali',
				),
				array(
					'location' => 'Rongpur',
				)
			)
		),


	)
) );