<?php
CSF::createSection( $prefix, array(
	'id' => 'autohive_header',
	'title'  => __( 'Header', 'autohive' ),
	'icon'  => 'fa fa-home',
) );

// Header Setting
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Header', 'autohive' ),
	'parent' => 'autohive_header',
	'icon'   => 'fa fa-home',
	'fields' => array(

		array(
			'type'    => 'subheading',
			'content' => esc_html__( 'Logo Settings', 'autohive' ),
		),

		array(
			'id'        => 'main_logo',
			'type'      => 'media',
			'title'     => esc_html__( 'Logo Upload', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'desc'      => esc_html__( 'Upload logo for Header', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'id'        => 'retina_logo',
			'type'      => 'media',
			'title'     => esc_html__( 'Retina Logo Upload @2x', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'desc'      => esc_html__( 'Upload your Retina Logo. This should be your Logo in double size (If your logo is 100 x 20px, it should be 200 x 40px)', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'id'        => 'sticky_logo',
			'type'      => 'media',
			'title'     => esc_html__( 'Sticky Logo', 'autohive' ),
			'desc'      => esc_html__( 'Upload logo for Header Sticky and Inner Page.', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'id'        => 'retina_logo_sticky',
			'type'      => 'media',
			'title'     => esc_html__( 'Sticky Retina Logo @2x', 'autohive' ),
			'desc'      => esc_html__( 'Upload Retina logo for Header Sticky.', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'type'    => 'heading',
			'content' => esc_html__( 'Mobile Logo', 'autohive' ),
		),

		array(
			'id'        => 'mobile_logo',
			'type'      => 'media',
			'title'     => esc_html__( 'Mobile Logo', 'autohive' ),
			'desc'      => esc_html__( 'Upload logo for mobile menu.', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'id'        => 'mobile_retina_logo',
			'type'      => 'media',
			'title'     => esc_html__( 'Mobile Retina Logo @2x', 'autohive' ),
			'desc'      => esc_html__( 'Upload Retina logo for mobile menu.', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'type'    => 'heading',
			'content' => esc_html__( 'Header Menu Style', 'autohive' ),
		),

		array(
			'id'     => 'menu_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Menu Text Color', 'autohive' ),
			'desc'   => esc_html__( 'You can change menu text color.', 'autohive' ),
			'output' => array(
				'color' => '.at_nav_menu ul li a',
			)
		),

		array(
			'id'     => 'menu_color_hover',
			'type'   => 'color',
			'title'  => esc_html__( 'Menu Text Hover Color', 'autohive' ),
			'desc'   => esc_html__( 'You can change menu text hover color.', 'autohive' ),
			'output' => array(
				'color'      => '.at_nav_menu ul li a:hover',
			)
		),

		array(
			'id'     => 'menu_bg_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Menu Background Color', 'autohive' ),
			'desc'   => esc_html__( 'You can change menu text hover color.', 'autohive' ),
			'output' => array(
				'background-color' => '.at_header_nav',
			)
		),

		array(
			'type'    => 'subheading',
			'content' => esc_html__( 'Header Sticky Menu Style', 'autohive' ),
		),

		array(
			'id'     => 'sticky_menu_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Menu Text Color', 'autohive' ),
			'desc'   => esc_html__( 'You can change menu text color.', 'autohive' ),
			'output' => [
				'color' => '.sticky-on .at_nav_menu ul li a',
			]
		),

		array(
			'id'        => 'sticky_menu_color_hover',
			'type'      => 'color',
			'title'     => esc_html__( 'Menu Text Hover Color', 'autohive' ),
			'desc'      => esc_html__( 'You can change menu text hover color.', 'autohive' ),
			'add_title' => esc_html__( 'Upload', 'autohive' ),
			'output' => [
				'color' => '.sticky-on .at_nav_menu ul li a',
			]
		),

		array(
			'id'     => 'sticky_menu_bg_color',
			'type'   => 'color',
			'title'  => esc_html__( 'Menu Background Color', 'autohive' ),
			'desc'   => esc_html__( 'You can change menu text hover color.', 'autohive' ),
			'output' => array(
				'background-color' => '.sticky-on .at_header_nav',
			)
		),
	)
) );

//Top Header Setting
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Header Top', 'autohive' ),
	'parent' => 'autohive_header',
	'icon'   => 'fa fa-arrow-up',
	'fields' => array(
		array(
			'id'    => 'top_left_text',
			'type'  => 'text',
			'subtitle' => __( 'Use mark tag for marked text', 'autohive' ),
			'title' => esc_html__( 'Top Left Text', 'autohive' ),
			'default' => esc_html__('Welcome!... Proof of Quality Is On the Autohive', 'autohive')
		),

		array(
			'id'     => 'top_right_text',
			'type'   => 'repeater',
			'title'  => 'Repeater',
			'fields' => array(

				array(
					'id'    => 'content',
					'type'  => 'text',
					'title' => 'Content',
					'default' => 'Rock St 14, New york City, USA',
				),

				array(
					'id'    => 'content_link',
					'type'  => 'text',
					'title' => 'Title Link',
					'default' => '#',
				),

				array(
					'id'    => 'icon_class',
					'type'  => 'text',
					'title' => 'Icon Class',
					'default' => 'flaticon-location',
				),
			),
		),

	)
) );


// Title Bar Breadcrumb
CSF::createSection( $prefix, array(
	'title'  => esc_html__( 'Title Bar', 'autohive' ),
	'parent' => 'autohive_header',
	'icon'   => 'fa fa-server',
	'fields' => array(
		array(
			'id'    => 'banner_bg_img',
			'type'  => 'background',
			'background_gradient' => true,
			'title' => esc_html__( 'Background Image', 'autohive' ),
			'output' => '.breadcrumb-section::before'
		),

		array(
			'id'      => 'banner_shape1',
			'type'    => 'media',
			'title'   => esc_html__( 'Shape 01', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

		array(
			'id'      => 'banner_shape2',
			'type'    => 'media',
			'title'   => esc_html__( 'Shape 02', 'autohive' ),
			'default'	=> [
				'url'	=> AUTOHIVE_DIR_IMG .'/logo/logo.svg'
			]
		),

	)
) );