<?php
// Disable regenerating images while importing media
add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

// Change some options for the jQuery modal window
function autohive_ocdi_confirmation_dialog_options ( $options ) {
    return array_merge( $options, array(
        'width'       => 400,
        'dialogClass' => 'wp-dialog',
        'resizable'   => false,
        'height'      => 'auto',
        'modal'       => true,
    ) );
}
add_filter( 'pt-ocdi/confirmation_dialog_options', 'autohive_ocdi_confirmation_dialog_options', 10, 1 );

function autohive_ocdi_intro_text_( $default_text ) {
    $default_text .= '<div class="ocdi_custom-intro-text notice notice-info inline">';
    $default_text .= sprintf (
        '%1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
        esc_html__( 'Install and activate all ', 'autohive' ),
        get_admin_url(null, 'themes.php?page=tgmpa-install-plugins' ),
        esc_html__( 'required plugins', 'autohive' ),
        esc_html__( 'before you click on the "Import" button.', 'autohive' )
    );
    $default_text .= sprintf (
        ' %1$s <a href="%2$s" target="_blank">%3$s</a> %4$s',
        esc_html__( 'You will find all the pages in ', 'autohive' ),
        get_admin_url(null, 'edit.php?post_type=page' ),
        esc_html__( 'Pages.', 'autohive' ),
        esc_html__( 'Other pages will be imported along with the main Homepage.', 'autohive' )
    );
    $default_text .= '<br>';
    $default_text .= sprintf (
        '%1$s <a href="%2$s" target="_blank">%3$s</a>',
        esc_html__( 'If you fail to import the demo data, follow the alternative way', 'autohive' ),
        'https://is.gd/R6jpHq',
        esc_html__( 'here.', 'autohive' )
    );
    $default_text .= '</div>';

    return $default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'autohive_ocdi_intro_text_' );



// OneClick Demo Importer
add_filter( 'pt-ocdi/import_files', 'autohive_import_files' );
function autohive_import_files() {
    return array (

        array(
            'import_file_name'             => esc_html__( 'Car Dealership', 'autohive' ),
            'import_file_url'              => 'https://autohive-wp.themetags.com/files/demo-data/autohive-demo.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demos/all/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demos/img/car_dealership.png',
            'preview_url'                  => 'https://autohive-wp.themetags.com/',
            'import_json'            => array(
                array(
                    'file_url'   => 'https://autohive-wp.themetags.com/files/demo-data/autohive-option.json',
                    'option_name' => 'autohive_cs_opt',
                ),
            ),
        ),

        array(
            'import_file_name'             => esc_html__( 'Rent Home', 'autohive' ),
            'import_file_url'              => 'https://autohive-wp.themetags.com/files/demo-data/autohive-demo.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demos/all/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demos/img/rent_home.png',
            'preview_url'                  => 'https://autohive-wp.themetags.com/rent-home/',
            'import_json'            => array(
                array(
                    'file_url'   => 'https://autohive-wp.themetags.com/files/demo-data/autohive-option.json',
                    'option_name' => 'autohive_cs_opt',
                ),
            ),
        ),

        array(
            'import_file_name'             => esc_html__( 'Auto Parts', 'autohive' ),
            'import_file_url'              => 'https://autohive-wp.themetags.com/files/demo-data/autohive-demo.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demos/all/widgets.wie',
            'import_preview_image_url'     => trailingslashit( get_template_directory_uri() ) . 'inc/demos/img/autoparts.png',
            'preview_url'                  => 'https://autohive-wp.themetags.com/home-auto-parts/',
            'import_json'            => array(
                array(
                    'file_url'   => 'https://autohive-wp.themetags.com/files/demo-data/autohive-option.json',
                    'option_name' => 'autohive_cs_opt',
                ),
            ),
        )


    );
}

function autohive_after_import_setup($selected_import) {

    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array (
            'main_menu' => $main_menu->term_id,
        )
    );

    // Disable Elementor's Default Colors and Default Fonts
    update_option( 'elementor_disable_color_schemes', 'yes' );
    update_option( 'elementor_disable_typography_schemes', 'yes' );
    update_option( 'elementor_global_image_lightbox', '' );

	// Assign front page and posts page (blog page).
	if ( 'Car Dealership' == $selected_import['import_file_name'] ) {
		$front_page_id = get_page_by_title( 'Home - Car Dealership' );
	}

	if ( 'Rent Home' == $selected_import['import_file_name'] ) {
		$front_page_id = get_page_by_title( 'Rent Home' );
	}

	if ( 'Auto Parts' == $selected_import['import_file_name'] ) {
		$front_page_id = get_page_by_title( 'Home - Auto Parts' );
	}


    $blog_page_id  = get_page_by_title( 'Blog' );

    // Set the home page and blog page
    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}

add_action( 'pt-ocdi/after_import', 'autohive_after_import_setup' );