<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
/**
* Autohive Walker Comment
*
*
* @class        Autohive_Walker_Comment
* @version      1.0
* @category     Class
* @author       ThemeTags
*/

if (!class_exists('Autohive_Walker_Comment')) {
    class Autohive_Walker_Comment extends Walker_Comment {
        public function start_el( &$output, $comment, $depth = 0, $args = array(), $id = 0 ) {
            $depth++;
            $GLOBALS['comment_depth'] = $depth;
            $GLOBALS['comment']       = $comment;
            if ( ! empty( $args['callback'] ) ) {
                ob_start();
                call_user_func( $args['callback'], $comment, $args, $depth );
                $output .= ob_get_clean();
                return;
            }
            if ( ( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ) && $args['short_ping'] ) {
                ob_start();
                $this->ping( $comment, $depth, $args );
                $output .= ob_get_clean();
            } else {
                ob_start();
                $this->comment( $comment, $depth, $args );
                $output .= ob_get_clean();
            }
        }


        protected function ping( $comment, $depth, $args ) {
            $tag = ( 'div' == $args['style'] ) ? 'div' : 'li'; ?>

            <<?php echo Autohive_Theme_Helper::render_html($tag); ?> id="comment-<?php comment_ID(); ?>" <?php comment_class( '', $comment ); ?>>
                <div class="comment-body stand_comment">
                    <?php esc_html_e( 'Pingback:', 'autohive' ); ?> <?php comment_author_link( $comment ); ?> <?php edit_comment_link( esc_html__( '(Edit)', 'autohive' ), '<span class="edit-link">', '</span>' ); ?>
                </div>
            <?php
        }

        protected function comment( $comment, $depth, $args ) {
            $max_depth_comment = ($args['max_depth'] > 4 ? 4 : $args['max_depth']);

            $GLOBALS['comment'] = $comment; ?>

            <li <?php comment_class( 'comment-box d-sm-flex' ); ?> id="comment-<?php comment_ID() ?>">
                <div class="thumbnail flex-shrink-0" >
	                <?php echo get_avatar($comment->comment_author_email, 86, '', '', array( 'class' => 'img-fluid rounded-circle' ) ); ?>
                </div>
                <span class="date text-primary"><?php printf('%1$s', get_comment_date()) ?></span>
                <div class="comments_content ms-sm-4 mt-4 mt-sm-0 overflow-hidden">
                    <h6 class="mb-3"><?php printf('%s', get_comment_author_link()) ?></h6>
                    <?php comment_text() ?>
	                <?php comment_reply_link(array_merge( $args, array(
		                'reply_text' =>   __('<span class="me-1"><i class="fa-solid fa-reply"></i></span> Reply', 'autohive'),
		                'depth' => $depth,
		                'max_depth' => $args['max_depth']
	                )));
	                ?>
                </div>
            </li>
            <?php
        }
    }
}