<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Autohive Theme Breadcrumb
 *
 *
 * @class        Autohive_Breadcrumb
 * @version      1.0
 * @category 	 Class
 * @author       ThemeTags
 */

if ( ! class_exists( 'Autohive_Breadcrumb' ) ) {
	class Autohive_Breadcrumb {



		public static function breadcrumb( $class = '') {

			// Settings
			$separator	         = '|';
			$breadcrums_id	     = 'breadcrumbs';
			$breadcrums_class	 = 'breadcrumb ' . $class;
			$home_title          = esc_html__('Home',  'autohive' );

			// If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
			$custom_taxonomy	 = 'product_cat';

			// Get the query & post information
			global $post;

			// Do not display on the homepage
			if ( !is_front_page() && !is_home() && !is_search() ) {

				// Build the breadcrums
				echo '<ol id="' . $breadcrums_id . '" class="' . $breadcrums_class . '">';

				// Home page
				echo '<li class="breadcrumb-item item-home"><a class="breadcrumb-link breadcrumb-home" href="' . esc_url(get_home_url()) . '" title="' . $home_title . '">' . $home_title . '</a></li>';
				if ( is_author() ) {

					// If post is a custom post type
					$post_type = get_post_type();

					$custom_tax_name = get_the_author_meta('display_name');
					echo '<li class="breadcrumb-item item-current item-archive"><span class="breadcrumb-current breadcrumb-archive">' . $custom_tax_name . '</span></li>';
				} else if (class_exists('WooCommerce') && is_product()) {
					echo '<li class="breadcrumb-item item-current item-archive"><span class="breadcrumb-current breadcrumb-archive">' . get_the_title('') . '</span></li>';
				} else if (class_exists('WooCommerce') && is_woocommerce()) {
					echo '<li class="breadcrumb-item item-current item-archive"><span class="breadcrumb-current breadcrumb-archive">' . woocommerce_page_title('') . '</span></li>';
				} else if (class_exists( 'bbPress' ) && is_bbpress() ) {
					echo '<li class="breadcrumb-item item-current item-archive"><span class="breadcrumb-current breadcrumb-archive">' . get_the_title() . '</span></li>';
				} else if ( is_archive() && !is_tax() && !is_category() && !is_tag() ) {

					echo '<li class="breadcrumb-item item-current item-archive"><span class="breadcrumb-current breadcrumb-archive">' . get_the_archive_title() . '</span></li>';

				} else if ( is_archive() && is_tax() && !is_category() && !is_tag() ) {

					// If post is a custom post type
					$post_type = get_post_type();

					// If it is a custom post type display name and link
					if($post_type != 'post') {

						$post_type_object = get_post_type_object($post_type);
						$post_type_archive = get_post_type_archive_link($post_type);

						echo '<li class="breadcrumb-item item-cat item-custom-post-type-' . $post_type . '"><a class="breadcrumb-cat breadcrumb-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a></li>';

					}

					$custom_tax_name = get_queried_object()->name;
					echo '<li class="breadcrumb-item item-current item-archive"><span class="breadcrumb-current breadcrumb-archive">' . $custom_tax_name . '</span></li>';

				} else if ( is_single() ) {

					// If post is a custom post type
					$post_type = get_post_type();

					// If it is a custom post type display name and link
					if($post_type != 'post') {

						$post_type_object = get_post_type_object($post_type);
						$post_type_archive = get_post_type_archive_link($post_type);

						echo '<li class="breadcrumb-item item-cat item-custom-post-type-' . $post_type . '"><a class="breadcrumb-cat breadcrumb-custom-post-type-' . $post_type . '" href="' . $post_type_archive . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a></li>';

					}

					// Get post category info
					$category = get_the_category();

					if(!empty($category)) {

						// Get last category post is in
						$all_category = array_values($category);
						$last_category = end($all_category);

						// Get parent any categories and create array
						$get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
						$cat_parents = explode(',',$get_cat_parents);

						// Loop through parent categories and store in variable $cat_display
						$cat_display    = '';
						foreach($cat_parents as $parents) {
							$cat_display .= $parents;
						}

					}

					// Check if the post is in a category
					if(!empty( $last_category ) ) {
						echo  '<li class="breadcrumb-item item-cat"> ' . $cat_display . ' </li>';
						echo '<li class="breadcrumb-item item-current item-' . $post->ID . '"><span class="breadcrumb-current breadcrumb-' . $post->ID . '" title="' . get_the_title() . '">'. wp_trim_words( get_the_title(), 3, '...' ) .'</span></li>';

						// Else if post is in a custom taxonomy
					} else if(!empty($cat_id)) {

						echo '<li class="breadcrumb-item item-cat item-cat-' . $cat_id . ' item-cat-' . $cat_nicename . '"><a class="breadcrumb-cat breadcrumb-cat-' . $cat_id . ' breadcrumb-cat-' . $cat_nicename . '" href="' . $cat_link . '" title="' . $cat_name . '">' . $cat_name . '</a></li>';
						echo '<li class="breadcrumb-item item-current item-' . $post->ID . ' active">' . get_the_title() . '</li>';

					} else {

						echo '<li class="breadcrumb-item item-current item-' . $post->ID . ' active">' . get_the_title() . '</li>';

					}

				} else if ( is_category() ) {

					// Category page
					echo '<li class="breadcrumb-item item-current item-cat"><span class="breadcrumb-current breadcrumb-cat">' . single_cat_title('', false) . '</span></li>';

				} else if ( is_home() ) {
					echo '<li class="breadcrumb-item active item-cat"><span class="breadcrumb-current breadcrumb-cat">' . wp_title('', false) . '</span></li>';

				} else if ( is_page() ) {

					// Standard page
					if( $post->post_parent ){

						// If child page, get parents
						$anc = get_post_ancestors( $post->ID );

						// Get parents in the right order
						$anc = array_reverse($anc);
						$parents = '';
						// Parent page loop
						foreach ( $anc as $ancestor ) {
							$parents .= $ancestor;
							echo '<li class="breadcrumb-item item-parent item-parent-' . $ancestor . '"><a class="breadcrumb-parent breadcrumb-parent-' . $ancestor . '" href="' . get_permalink($ancestor) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a></li>';
						}

						// Current page
						echo '<li class="breadcrumb-item item-current item-' . $post->ID . '"><span title="' . get_the_title() . '"> ' . get_the_title() . '</span></li>';

					} else {

						// Just display current page if not parents
						echo '<li class="breadcrumb-item item-current item-' . $post->ID . '"><span class="breadcrumb-current breadcrumb-' . $post->ID . '"> ' . get_the_title() . '</span></li>';

					}

				} else if ( is_tag() ) {

					// Tag page

					// Get tag information
					$term_id	 = get_query_var('tag_id');
					$taxonomy	 = 'post_tag';
					$args	 = 'include=' . $term_id;
					$terms	 = get_terms( $taxonomy, $args );
					$get_term_id	 = $terms[0]->term_id;
					$get_term_slug	 = $terms[0]->slug;
					$get_term_name	 = $terms[0]->name;

					// Display the tag name
					echo '<li class="breadcrumb-item item-current item-tag-' . $get_term_id . ' item-tag-' . $get_term_slug . '"><span class="breadcrumb-current breadcrumb-tag-' . $get_term_id . ' breadcrumb-tag-' . $get_term_slug . '">' . $get_term_name . '</span></li>';

				} elseif ( is_day() ) {

					// Day archive

					// Year link
					echo '<li class="breadcrumb-item item-year item-year-' . get_the_time('Y') . '"><a class="breadcrumb-year breadcrumb-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives', 'autohive') .'</a></li>';
					echo '<li class="breadcrumb-item separator separator-' . get_the_time('Y') . '"> ' . $separator . ' </li>';

					// Month link
					echo '<li class="breadcrumb-item item-month item-month-' . get_the_time('m') . '"><a class="breadcrumb-month breadcrumb-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . esc_html__(' Archives', 'autohive') .'</a></li>';
					echo '<li class="breadcrumb-item separator separator-' . get_the_time('m') . '"> ' . $separator . ' </li>';

					// Day display
					echo '<li class="breadcrumb-item item-current item-' . get_the_time('j') . '"><span class="breadcrumb-current breadcrumb-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') . esc_html__(' Archives', 'autohive') .'</span></li>';

				} else if ( is_month() ) {

					// Month Archive

					// Year link
					echo '<li class="breadcrumb-item item-year item-year-' . get_the_time('Y') . '"><a class="breadcrumb-year breadcrumb-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives', 'autohive') .' </a></li>';
					echo '<li class="breadcrumb-item separator separator-' . get_the_time('Y') . '"> ' . $separator . ' </li>';

					// Month display
					echo '<li class="breadcrumb-item item-month item-month-' . get_the_time('m') . '"><span class="breadcrumb-month breadcrumb-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . esc_html__(' Archives', 'autohive') .' </span></li>';

				} else if ( is_year() ) {

					// Display year archive
					echo '<li class="breadcrumb-item item-current item-current-' . get_the_time('Y') . '"><span class="breadcrumb-current breadcrumb-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives', 'autohive').' </span></li>';

				} else if ( is_author() ) {

					// Auhor archive

					// Get the author information
					global $author;
					$userdata = get_userdata( $author );

					// Display author name
					echo '<li class="breadcrumb-item item-current item-current-' . $userdata->user_nicename . '"><span class="breadcrumb-current breadcrumb-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' . esc_html__( 'Author: ', 'autohive' ) . $userdata->display_name . '</span></li>';

				} else if ( get_query_var('paged') ) {

					// Paginated archives
					echo '<li class="breadcrumb-item item-current item-current-' . get_query_var('paged') . '"><span class="breadcrumb-current breadcrumb-current-' . get_query_var('paged') . '" title="Page ' . get_query_var('paged') . '">'.esc_html__('Page', 'autohive' ) . ' ' . get_query_var('paged') . '</span></li>';

				} elseif ( is_404() ) {

					// 404 page
					echo '<li>'. esc_html__('404 Error', 'autohive') .'</li>';
				}

				echo '</ol>';

			}

		}

	}

	$obj = new Autohive_Breadcrumb();
}