<?php
/**
 * header.php
 *
 * The header for the theme.
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
if ( function_exists( 'wp_body_open' ) ) {
	wp_body_open();
}
	do_action( 'autohive_after_body' );
    ?>

    <div class="ring-preloader w-100 h-100 position-fixed start-0 top-0">
        <div class="lds-dual-ring"></div>
    </div>

    <!--main content wrapper start-->
    <div class="main-wrapper">

		<?php
		//Site Header
		if ( !is_404()) {
			get_template_part( 'template-parts/header/header' );
		
			get_template_part( 'template-parts/offcanvas' );

            // Page Banner Area
			get_template_part( 'template-parts/header/page-banner' );
		}
		?>