<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage autohive
 * @since 1.0
 * @version 1.0
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}


$is_comments = have_comments() ? 'have_comments' : 'no_comments';

if ( have_comments() ) {
	?>

    <hr class="mt-40 mb-40 clear-both">
    <div class="comments_inner <?php echo esc_attr($is_comments); ?>" id="comments">
        <h4><?php echo esc_html(Autohive_Theme_Helper::get_the_comment_count(get_the_ID())) ?></h4>
        <ul class="comments_list mt-40">
			<?php
			wp_list_comments(
				array(
					'style'         => 'ul',
					'short_ping'    => true,
					'avatar_size' => 60,
					'walker'        => new Autohive_Walker_Comment,
				)
			);
			the_comments_navigation();
			?>
        </ul>
    </div>
	<?php
}
?>
<hr class="mt-40 mb-40 clear-both">
    <?php

// Comment Box
if ( comments_open() ) {
	?>
    <div class="comment_form_wrapper <?php echo esc_attr($is_comments) ?>">
        <?php
        $commenter      = wp_get_current_commenter();
        $req            = get_option( 'require_name_email' );
        $aria_req       = ( $req ? " aria-required='true'" : '' );
        $fields =  array(
                'author' => '<div class="col-sm-6"> <div class="input-field"> <input type="text" name="author" id="name" value="'.esc_attr($commenter['comment_author']).'" placeholder="'.esc_attr__('Name', 'autohive').'" '.$aria_req.'></div> </div>',
                'email'	=> '<div class="col-sm-6"> <div class="input-field"> <input type="email" name="email" id="email" value="'.esc_attr($commenter['comment_author_email']).'" placeholder="'.esc_attr__('Email', 'autohive').'" '.$aria_req.'></div></div>',
                'url'	=> '<div class="col-sm-12"> <div class="input-field"> <input type="email" name="url" id="url" value="'.esc_attr($commenter['comment_author_url']).'" placeholder="'.esc_attr__('Website', 'autohive').'" '.$aria_req.'></div> </div>',
        );
        $comments_args = array(
            'fields'                => apply_filters( 'comment_form_default_fields', $fields ),
            'class_form'            => 'comment_form mb-0',
            'class_submit'          => 'btn btn-primary mt-30',
            'title_reply_before'    => '<h4 class="blog_title">',
            'title_reply'           => esc_html__( 'Leave a Comment', 'autohive' ),
            'title_reply_after'     => '</h4>',
            'comment_notes_before'  => '',
            'comment_field'         => '<div class="col-sm-12"> <div class="input-field"><textarea name="comment" id="comment" rows="5" placeholder="'.esc_attr__('Write your comment here', 'autohive').'"></textarea></div></div>',
            'submit_button'         => '<button name="%1$s" type="submit" id="%2$s" class="%3$s" value="%4$s">'. esc_html__( 'Post Comment', 'autohive' ).'</button>',
            'comment_notes_after'   => '',
        );
        comment_form($comments_args);
        ?>
    </div>
	<?php
} else {
	if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) { ?>
        <p class="no-comments mb-0"><?php esc_html_e( 'Comments are closed.', 'autohive' ); ?></p>
	    <?php
	}
}