<?php
/**
 * The template for displaying 404 pages (Not Found).
 * @package autohive
 * by ThemeTags
 */
get_header();

$image         = autohive_opt( 'error_image' );
$error_text    = autohive_opt( 'error_text' );
$error_title   = autohive_opt( 'error_title' );
$error_content = autohive_opt( 'error_description' );
?>

<section class="error_page d-flex align-items-center vh-100">
	<div class="container">
		<div class="error_page_wrapper">
			<div class="row">
				<div class="col-lg-6">
					<div class="error-page-content">
						<div class="error-info ">
							<?php if ( ! empty( $error_title )) : ?>
								<h1 class="error-text"><?php echo esc_html($error_text); ?></h1>
							<?php else :
								echo '<h1 class="error-text">' . esc_html__('404', 'autohive') . '</h1>';
							endif; ?>

							<?php if ( ! empty( $error_title )) : ?>
								<h2 class="error-title mt-2 mb-1 h1"><?php echo esc_html($error_title); ?></h2>
							<?php else :
								echo '<h2 class="error-title mt-2 mb-2 h1">' . esc_html__('Page not Found', 'autohive') . '</h2>';
							endif; ?>

							<?php if ( ! empty( $error_content )) : ?>
								<p class="lead mb-4 mt-3"><?php echo esc_html($error_content); ?></p>
							<?php else :
								echo '<p class="lead mb-4 mt-3">' . esc_html__('We are sorry, the page you have looked for does not exist in our database! Maybe go to our home page or try to use a search?', 'autohive') . '</p>';
							endif; ?>

							<a href="<?php echo esc_url(home_url('/')); ?>" class="btn btn-primary"><?php echo esc_html__('Back to Home', 'autohive') ?></a>
						</div>
					</div>
				</div>
				<!-- /.col-lg-6 -->

				
			</div>
			<!-- /.row -->
		</div>
	</div>
</section>

<?php

get_footer();

