<?php
// Prevent loading this file directly
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Autohive_Header' ) ) {
	class Autohive_Header {
		private $type = 'mega_menu';
		private $slug = 'mega_menu';
		private $name;
		private $tem;
		private $singular_name;
		private $plural_name;

		function __construct() {
			$this->name = __( 'Mega Menu', 'autohive-core' );
			$this->singular_name = __( 'Item', 'autohive-core' );
			$this->plural_name = __( 'Items', 'autohive-core' );


			add_action( 'init', array( $this, 'register_post_types' ), 1 );
//			add_action( 'init', array( $this, 'register_mega_menu_taxonomy' ), 1 );
		}

		function register_post_types() {
			$labels = array(
				'name'                  => esc_html__( 'Mega Menu', 'autohive-core' ),
				'singular_name'         => esc_html__( 'Mega Menu', 'autohive-core' ),
				'all_items'             => esc_html__( 'All Menus', 'autohive-core' ),
				'menu_name'             => _x( 'Mega Menu', 'Admin menu name', 'autohive-core' ),
				'add_new'               => esc_html__( 'Add New', 'autohive-core' ),
				'add_new_item'          => esc_html__( 'Add new Menu', 'autohive-core' ),
				'edit'                  => esc_html__( 'Edit', 'autohive-core' ),
				'edit_item'             => esc_html__( 'Edit Footer', 'autohive-core' ),
				'new_item'              => esc_html__( 'New Menu', 'autohive-core' ),
				'view'                  => esc_html__( 'View Menu', 'autohive-core' ),
				'view_item'             => esc_html__( 'View Menu', 'autohive-core' ),
				'search_items'          => esc_html__( 'Search Menus', 'autohive-core' ),
				'not_found'             => esc_html__( 'No Menus found', 'autohive-core' ),
				'not_found_in_trash'    => esc_html__( 'No Menus found in trash', 'autohive-core' ),
				'parent'                => esc_html__( 'Parent Menu', 'autohive-core' ),
				'filter_items_list'     => esc_html__( 'Filter Menus', 'autohive-core' ),
				'items_list_navigation' => esc_html__( 'Menus navigation', 'autohive-core' ),
				'items_list'            => esc_html__( 'Menu list', 'autohive-core' ),
			);

			$supports = array(
				'title',
				'editor',
				'elementor',
			);

			register_post_type( $this->type, array(
				'labels'      => $labels,
				'supports'    => $supports,
				'public'=>true,
				'show_in_nav_menus' => true,
				'show_admin_column' => false,
				'hierarchical'      => true,
				'show_tagcloud'     => false,
				'show_ui'           => true,
				'rewrite'     => array(
					'slug' => $this->slug,
				),
				'can_export'  => true,
				'menu_icon'   => 'dashicons-download',
			) );

			flush_rewrite_rules( true );
		}

		function register_mega_menu_taxonomy() {
			$category = 'category'; // Second part of taxonomy name

			$labels = array(
				'name' => sprintf( __( '%s Categories', 'autohive-core' ), $this->name ),
				'menu_name' => sprintf( __( '%s Categories','autohive-core' ), $this->name ),
				'singular_name' => sprintf( __( '%s Category', 'autohive-core' ), $this->name ),
				'search_items' =>  sprintf( __( 'Search %s Categories', 'autohive-core' ), $this->name ),
				'all_items' => sprintf( __( 'All %s Categories','autohive-core' ), $this->name ),
				'parent_item' => sprintf( __( 'Parent %s Category','autohive-core' ), $this->name ),
				'parent_item_colon' => sprintf( __( 'Parent %s Category:','autohive-core' ), $this->name ),
				'new_item_name' => sprintf( __( 'New %s Category Name','autohive-core' ), $this->name ),
				'add_new_item' => sprintf( __( 'Add New %s Category','autohive-core' ), $this->name ),
				'edit_item' => sprintf( __( 'Edit %s Category','autohive-core' ), $this->name ),
				'update_item' => sprintf( __( 'Update %s Category','autohive-core' ), $this->name ),
			);
			$args = array(
				'labels' => $labels,
				'hierarchical' => true,
				'show_ui' => true,
				'show_admin_column' => true,
				'query_var' => true,
				'rewrite' => array( 'slug' => $this->slug.'-'.$category ),
			);
			register_taxonomy( $this->type.'-'.$category, array($this->type), $args );
		}
	}

	new Autohive_Header;
}
